﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupMakeAppointment;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class MakeGroupAppointmentProcessor
    {
        public IMessageBase Execute(MakeGroupAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetAppointmentStep>("GetAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetProvidersStep>("GetProvidersStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetFacilitiesStep>("GetFacilitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, GetClinicsStep>("GetClinicsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, MapPatGroupAppointmentRequestStep>("MapPatGroupAppointmentRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, MapProGroupAppointmentRequestStep>("MapProGroupAppointmentRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, SendBothLoginsToEcStep>("SendBothLoginsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, SerializeEcRequestStep>("SerializeEcRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, SendBothAppointmentsToEcStep>("SendBothAppointmentsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeGroupAppointmentStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());
            
            using (var state = new MakeGroupAppointmentStateObject(request))
            {
                new Pipeline<MakeGroupAppointmentStateObject>()
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetProvidersStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetFacilitiesStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("GetClinicsStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("MapPatGroupAppointmentRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("MapProGroupAppointmentRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("SendBothLoginsToEcStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("SerializeEcRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("SendBothAppointmentsToEcStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeGroupAppointmentStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.MakeGroupAppointmentResponseMessage;
            }

        }
    }
}
