﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class MakeAppointmentProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(MakeAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeAppointmentStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetProvidersStep>("GetProvidersStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetFacilitiesStep>("GetFacilitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, GetClinicsStep>("GetClinicsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, MapPatientSideApptRequestStep>("MapPatientSideApptRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, MapProviderSideApptRequestStep>("MapProviderSideApptRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, SendBothLoginsToEcStep>("SendBothLoginsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, SerializeEcRequestStep>("SerializeEcRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, SendBothAppointmentsToEcStep>("SendBothAppointmentsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeAppointmentStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new MakeAppointmentStateObject(request))
            {
                new Pipeline<MakeAppointmentStateObject>()
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetProvidersStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetFacilitiesStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("GetClinicsStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("MapPatientSideApptRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("MapProviderSideApptRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("SendBothLoginsToEcStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("SerializeEcRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("SendBothAppointmentsToEcStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeAppointmentStateObject>>("StopProcessingStep"))
                    .Execute(state);
                
                return state.MakeAppointmentResponseMessage;
            }
        }
    }
}
