﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class CancelGroupAppointmentProcessor
    {
        public IMessageBase Execute(CancelGroupAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, GetAppointmentStep>("GetAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, GetClinicsStep>("GetClinicsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, GetFacilitiesStep>("GetFacilitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, MapToPatGroupCancelRequestStep>("MapToPatGroupCancelRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, MapToProGroupCancelRequestStep>("MapToProGroupCancelRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, SerializeEcRequestStep>("SerializeEcRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, CancelAppointmentStep>("CancelAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelGroupAppointmentStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());
                
            using (var state = new CancelGroupAppointmentStateObject(request))
            {
                new Pipeline<CancelGroupAppointmentStateObject>()
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("GetAppointmentStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("GetClinicsStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("GetFacilitiesStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("MapToPatGroupCancelRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("MapToProGroupCancelRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("SerializeEcRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("CancelAppointmentStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<CancelGroupAppointmentStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.CancelGroupAppointmentResponse;
            }

        }
    }
}
