﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.CancelAppointment;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class CancelAppointmentProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(CancelAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<CancelAppointmentStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, GetServiceActivityStep>("GetServiceActivityStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>()).RegisterType<FilterBase<CancelAppointmentStateObject>, GetFacilitiesStep>("GetFacilitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>()).RegisterType<FilterBase<CancelAppointmentStateObject>, GetClinicsStep>("GetClinicsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, GetProviderStep>("GetProviderStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, MapToPatCancelAppointmentRequestStep>("MapToPatCancelAppointmentRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, MapToProCancelAppointmentRequestStep>("MapToProCancelAppointmentRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, SendBothLoginsToEcStep>("SendBothLoginsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, SerializeEcRequestStep>("SerializeEcRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, SendBothAppointmentsToEcStep>("SendBothAppointmentsToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<CancelAppointmentStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new CancelAppointmentStateObject(request))
            {
                new Pipeline<CancelAppointmentStateObject>()
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetServiceActivityStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetFacilitiesStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetClinicsStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("GetProviderStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("MapToPatCancelAppointmentRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("MapToProCancelAppointmentRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("SendBothLoginsToEcStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("SerializeEcRequestStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("SendBothAppointmentsToEcStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<CancelAppointmentStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.CancelAppointmentResponse;
            }
        }
    }
}
