﻿using System;
using System.ComponentModel.Composition;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.ViaLoginRequestMessage)]
    public class ViaLoginHandler : RequestResponseHandler
    {
        private ViaLoginRequestMessage _request;
        private string _serializedRequest;
        private Stopwatch timer;

        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                timer = new Stopwatch();
                timer.Start();
                _request = (ViaLoginRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new ViaLoginProcessor();
                var response = (ViaLoginResponseMessage)processor.Execute(_request);
                if (response != null && response.ExceptionOccured) Logger.Instance.Error(string.Format("Error in ViaLogin Pipeline: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                response.SerializedInstance = response.SerializedInstance;
                timer.Stop();
                response.VIMTProcessingTime = (int)timer.ElapsedMilliseconds;

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        private MakeGroupAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: ViaLogin", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new MakeGroupAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}