﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.GetConsultsForPatientRequest)]
    public class GetConsultsForPatientHandler : RequestResponseHandler
    {
        private GetConsultsForPatientRequest _request;
        private string _serializedRequest;
        private Stopwatch timer;

        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                timer = new Stopwatch();
                timer.Start();
                _request = (GetConsultsForPatientRequest)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new GetConsultsForPatientProcessor();
                var response = (GetConsultsForPatientResponse)processor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: GetConsults Pipeline: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                timer.Stop();
                response.VIMTProcessingTime = (int)timer.ElapsedMilliseconds;

                return response;
            } 
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        private GetConsultsForPatientResponse LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VideoVisit Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);
            timer.Stop();

            return new GetConsultsForPatientResponse
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest,
                VIMTProcessingTime = (int)timer.ElapsedMilliseconds
            };
        }
    }
}
