﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.CancelGroupAppointmentRequestMessage)]
    public class CancelGroupAppointmentHandler : RequestResponseHandler
    {
        CancelGroupAppointmentRequestMessage _request;
        private string _serializedRequest;
        private Stopwatch timer;
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                timer = new Stopwatch();
                timer.Start();
                _request = (CancelGroupAppointmentRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new CancelGroupAppointmentProcessor();
                var response = (CancelGroupAppointmentResponseMessage)processor.Execute(_request);

                if (response != null && response.ExceptionOccured) Logger.Instance.Error(string.Format("Error in Cancel Group Appointment Pipeline: {0}",response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                timer.Stop();
                response.VIMTProcessingTime = (int)timer.ElapsedMilliseconds;

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        private CancelGroupAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: Cancel Group Appointment Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);
            timer.Stop();
            return new CancelGroupAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest,
                VIMTProcessingTime = (int)timer.ElapsedMilliseconds
            };
        }
    }
}
