﻿using System;
using System.ComponentModel.Composition;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.CancelAppointmentRequestMessage)]
    public class CancelAppointmentHandler : RequestResponseHandler
    {
        private CancelAppointmentRequestMessage _request;
        private string _serializedRequest;
        private Stopwatch timer;
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                timer = new Stopwatch();
                timer.Start();
                _request = (CancelAppointmentRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new CancelAppointmentProcessor();
                var response = (CancelAppointmentResponseMessage)processor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Cancel Appointment Pipeline: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                timer.Stop();
                response.VIMTProcessingTime = (int)timer.ElapsedMilliseconds;
                return response;
            }
            catch(Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }


        private CancelAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: Cancel Appointment Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            timer.Stop();
            return new CancelAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest,
                VIMTProcessingTime = (int)timer.ElapsedMilliseconds
            };
        }
    }
}
