﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.OptionSets;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;
using Microsoft.Xrm.Sdk.Query;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public static class VistaMapperHelper
    {
        public static VIMTVIASchdMakeApptReqqueryBean GetQueryBean(MakeGroupAppointmentStateObject state, Side side)
        {
            var siteCode = side == Side.Patient ? state.PatFacility.mcs_StationNumber : state.ProFacility.mcs_StationNumber;
            var currentUser = state.OrganizationServiceProxy.Retrieve(SystemUser.EntityLogicalName, state.UserId, new ColumnSet(true));
            var queryBeanAppSettings = GetSecuritySettings(state.OrganizationServiceProxy);
            var patient = state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, state.MakeGroupAppointmentRequestMessage.AddedPatients.FirstOrDefault(), new ColumnSet(true)).ToEntity<Contact>();
            if (currentUser == null)
                throw new Exception("No Executing User passed into Integration pipeline (or user could not be found): " + state.UserId);
            return new VIMTVIASchdMakeApptReqqueryBean
            {
                mcs_requestingApp = queryBeanAppSettings.RequestingApp,
                mcs_consumingAppToken = queryBeanAppSettings.ConsumingAppToken,
                mcs_consumingAppPassword = queryBeanAppSettings.ConsumingAppPassword,
                mcs_multiSiteQuery = false,
                VIMTVIASchdMakeApptReqproviderInfo = new VIMTVIASchdMakeApptReqprovider
                {
                    mcs_name = GetProviderName(state),
                    mcs_loginSiteCode = siteCode,
                    mcs_vistaLocations = siteCode
                    //mcs_userId = GetViaLoginId(state, side) //Now handled in a separate pipeline step
                },
                VIMTVIASchdMakeApptReqpatientInfo = new VIMTVIASchdMakeApptReqpatient
                {
                    mcs_mpiPid = GetPatientICN(state),
                    mcs_localPid = GetPatientLocalPid(state, siteCode),
                    mcs_localSiteId = siteCode,
                    mcs_vistaLocations = siteCode,
                    mcs_name = patient.FullName
                },
                mcs_name = currentUser.ToEntity<SystemUser>().FullName,

            };
        }

        internal static VIMTVIAScheLIloginVIAResponse VistaLoginFakeResponse(string fakeResponseType)
        {
            if (fakeResponseType == "0")
                return new VIMTVIAScheLIloginVIAResponse
                {
                    VIMTVIAScheLIuserTOInfo = new VIMTVIAScheLIuserTO
                    {
                        mcs_DUZ = "FakeUserDuz",
                        mcs_greeting = "Good Afternoon, Test Name",
                        mcs_name = "Test Name",
                        mcs_siteId = "516"
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
            else
                return new VIMTVIAScheLIloginVIAResponse
                {
                    VIMTVIAScheLIuserTOInfo = new VIMTVIAScheLIuserTO
                    {
                        VIMTVIAScheLIfault2Info = new VIMTVIAScheLIfault2
                        {
                            mcs_message = "Unable to Sign in using Identity and Access Management STS Token.  Try using Access/Verify Codes instead"
                        }
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
        }

        public static VIMTVIASchdMakeApptReqqueryBean GetQueryBean(MakeAppointmentStateObject state, Side side)
        {
            var siteCode = side == Side.Patient ? state.PatFacility.mcs_StationNumber : state.ProFacility.mcs_StationNumber;
            var currentUser = state.OrganizationServiceProxy.Retrieve(SystemUser.EntityLogicalName, state.UserId, new ColumnSet(true));
            var queryBeanAppSettings = GetSecuritySettings(state.OrganizationServiceProxy);
            var patient = state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, state.MakeAppointmentRequestMessage.AddedPatients.FirstOrDefault(), new ColumnSet(true)).ToEntity<Contact>();
            if (currentUser == null)
                throw new Exception("No Executing User passed into Integration pipeline (or user could not be found): " + state.UserId);
            return new VIMTVIASchdMakeApptReqqueryBean
            {
                mcs_requestingApp = queryBeanAppSettings.RequestingApp,
                mcs_consumingAppToken = queryBeanAppSettings.ConsumingAppToken,
                mcs_consumingAppPassword = queryBeanAppSettings.ConsumingAppPassword,
                mcs_multiSiteQuery = false,
                VIMTVIASchdMakeApptReqproviderInfo = new VIMTVIASchdMakeApptReqprovider
                {
                    mcs_name = GetProviderName(state),
                    mcs_loginSiteCode = siteCode,
                    mcs_vistaLocations = siteCode
                    //mcs_userId = GetViaLoginId(state, side) //Now handled in a separate pipeline step
                },
                VIMTVIASchdMakeApptReqpatientInfo = new VIMTVIASchdMakeApptReqpatient
                {
                    mcs_mpiPid = GetPatientICN(state),
                    mcs_localPid = GetPatientLocalPid(state, siteCode),
                    mcs_localSiteId = siteCode,
                    mcs_vistaLocations = siteCode,
                    mcs_name = patient.FullName
                },
                mcs_name = GetProviderName(state),
                
            };
        }

        public static VIMTVIASchedCancApReqqueryBean GetQueryBean(CancelAppointmentStateObject state, Side side) 
        {
            var siteCode = side == Side.Patient ? state.PatFacility.mcs_StationNumber : state.ProFacility.mcs_StationNumber;
            var currentUser = state.OrganizationServiceProxy.Retrieve(SystemUser.EntityLogicalName, state.UserId, new ColumnSet(true));
            var queryBeanAppSettings = GetSecuritySettings(state.OrganizationServiceProxy);
            var patient = state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, state.CancelAppointmentRequest.CanceledPatients.FirstOrDefault(), new ColumnSet(true)).ToEntity<Contact>();

            if (currentUser == null)
                throw new Exception("No Executing User passed into Integration pipeline (or user could not be found): " + state.UserId);
            return new VIMTVIASchedCancApReqqueryBean
            {
                mcs_requestingApp = queryBeanAppSettings.RequestingApp,
                mcs_consumingAppToken = queryBeanAppSettings.ConsumingAppToken,
                mcs_consumingAppPassword = queryBeanAppSettings.ConsumingAppPassword,
                mcs_multiSiteQuery = false,
                VIMTVIASchedCancApReqproviderInfo = new VIMTVIASchedCancApReqprovider 
                {
                    mcs_name = GetProviderName(state),
                    mcs_loginSiteCode = siteCode,
                    mcs_vistaLocations = siteCode
                    //mcs_userId = GetViaLoginId(state, side) //Now handled in a separate pipeline step
                },
                VIMTVIASchedCancApReqpatientInfo = new VIMTVIASchedCancApReqpatient //VIMTVIASchdMakeApptReqpatientInfo
                {
                    mcs_mpiPid = GetPatientICN(state),
                    mcs_localPid = GetPatientLocalPid(state, siteCode),
                    mcs_localSiteId = siteCode,
                    mcs_vistaLocations = siteCode,
                    mcs_name = patient.FullName
                },
                mcs_name = GetProviderName(state),

            };
        }

        public static VIMTVIASchedCancApReqqueryBean GetQueryBean(CancelGroupAppointmentStateObject state, Side side)
        {
            var siteCode = side == Side.Provider ? state.ProviderFacility.mcs_StationNumber : state.PatientFacility.mcs_StationNumber;
            var currentUser = state.OrganizationServiceProxy.Retrieve(SystemUser.EntityLogicalName, state.UserId, new ColumnSet(true));
            var queryBeanAppSettings = GetSecuritySettings(state.OrganizationServiceProxy);
            var patient = state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, state.CancelGroupAppointmentRequest.CanceledPatients.FirstOrDefault(), new ColumnSet(true)).ToEntity<Contact>();
            if (currentUser == null)
                throw new Exception("No Executing User passed into Integration pipeline (or user could not be found): " + state.UserId);
            return new VIMTVIASchedCancApReqqueryBean
            {
                mcs_requestingApp = queryBeanAppSettings.RequestingApp,
                mcs_consumingAppToken = queryBeanAppSettings.ConsumingAppToken,
                mcs_consumingAppPassword = queryBeanAppSettings.ConsumingAppPassword,
                mcs_multiSiteQuery = false,
                VIMTVIASchedCancApReqproviderInfo = new VIMTVIASchedCancApReqprovider
                {
                    mcs_name = GetProviderName(state),
                    mcs_loginSiteCode = siteCode,
                    mcs_vistaLocations = siteCode
                    //mcs_userId = GetViaLoginId(state, side) //Now handled in a separate pipeline step
                },
                VIMTVIASchedCancApReqpatientInfo = new VIMTVIASchedCancApReqpatient //VIMTVIASchdMakeApptReqpatientInfo
                {
                    mcs_mpiPid = GetPatientICN(state),
                    mcs_localPid = GetPatientLocalPid(state, siteCode),
                    mcs_localSiteId = siteCode,
                    mcs_vistaLocations = siteCode,
                    mcs_name = patient.FullName
                },
                mcs_name = GetProviderName(state),

            };
        }


        public static string GetViaLoginId(VIMTVIAScheLIloginVIARequest request, Side side)
        {
            try
            {
                Logger.Instance.Debug(string.Format("Calling LoginVIA EC for {0} Side", side.ToString()));
                var loginResponse = request.SendReceive<VIMTVIAScheLIloginVIAResponse>(MessageProcessType.Local);
                Logger.Instance.Debug(string.Format("Exiting LoginVIA EC for {0} Side", side.ToString()));

                if (loginResponse == null)
                    throw new Exception(string.Format("VIA Login failed for {0} Site, no response was returned", side.ToString()));
                if (loginResponse.VIMTVIAScheLIuserTOInfo == null)
                    throw new Exception(string.Format("VIA Login failed for {0} Site, an empty response was returned", side.ToString()));
                if (loginResponse.ExceptionOccured)
                    throw new Exception(string.Format("VIA Login Failed for {0} Site. EC Error: {1}: {2}", side.ToString(), loginResponse.ExceptionMessage, loginResponse.VIMTVIAScheLIuserTOInfo?.VIMTVIAScheLIfault2Info?.mcs_message));
                if (loginResponse.VIMTVIAScheLIuserTOInfo.VIMTVIAScheLIfault2Info != null)
                    throw new Exception(string.Format("VIA Login Failed for {0} Site. VIA Error: {1}", side.ToString(), loginResponse.VIMTVIAScheLIuserTOInfo.VIMTVIAScheLIfault2Info.mcs_message));
                if (string.IsNullOrEmpty(loginResponse.VIMTVIAScheLIuserTOInfo.mcs_DUZ))
                    throw new Exception(string.Format("No User Id was returned from the Login Request for the {0} Site", side.ToString()));
                return loginResponse.VIMTVIAScheLIuserTOInfo.mcs_DUZ;
            }
            catch (Exception ex)
            {
                Logger.Instance.Error(string.Format("Failure to Login to {0} side with SAML: {1}", side.ToString(), ex.Message));
                throw;
            }
        }

        public static string GetPatientLocalPid(MakeGroupAppointmentStateObject state, string siteCode)
        {
            return GetPatientLocalPid(siteCode, state.MakeGroupAppointmentRequestMessage.AddedPatients.FirstOrDefault(), state.OrganizationServiceProxy);
        }

        public static string GetPatientLocalPid(MakeAppointmentStateObject state, string siteCode)
        {
            return GetPatientLocalPid(siteCode, state.MakeAppointmentRequestMessage.AddedPatients.FirstOrDefault(), state.OrganizationServiceProxy);
        }

        public static string GetPatientLocalPid(CancelAppointmentStateObject state, string siteCode)
        {
            return GetPatientLocalPid(siteCode, state.CancelAppointmentRequest.CanceledPatients.FirstOrDefault(), state.OrganizationServiceProxy);
        }

        public static string GetPatientLocalPid(CancelGroupAppointmentStateObject state, string siteCode)
        {
            return GetPatientLocalPid(siteCode, state.CancelGroupAppointmentRequest.CanceledPatients.FirstOrDefault(), state.OrganizationServiceProxy);
        }

        public static string GetPatientLocalPid(string siteCode, Guid patientId, IOrganizationService organizationService)
        {
            var personIdentifier = new mcs_personidentifiers();
            if (patientId == null)
                throw new Exception("Patient Cannot be null");
            using (var srv = new Xrm(organizationService))
            {
                personIdentifier = srv.mcs_personidentifiersSet.FirstOrDefault(p => p.mcs_patient.Id == patientId && p.mcs_assigningfacility == siteCode);
                if (personIdentifier == null)
                    throw new Exception(string.Format("Patient was not successfully registered to the Vista Station {0}, please confirm Proxy Add ran successfully", siteCode));
            }
            return personIdentifier.mcs_identifier;
        }


        public static mcs_facility GetFacility(MakeAppointmentStateObject state, Side side)
        {
            EntityReference siteLookup;
            if (side == Side.Provider)
            {
                if (state.AppointmentType != AppointmentType.STORE_FORWARD)
                    siteLookup = state.ServiceAppointment.mcs_relatedprovidersite;
                else
                    throw new Exception("No Provider Side Encounter should be booked for a Store/Forward Appointment");
            }
            else
            {
                if (state.AppointmentType == AppointmentType.GROUP)
                    siteLookup = state.CrmAppointment.cvt_Site;
                else if (state.AppointmentType == AppointmentType.HOME_MOBILE)
                    throw new Exception("No Patient Side Encounter should be booked for a Home/Mobile Appointment");
                else
                    siteLookup = state.ServiceAppointment.mcs_relatedsite;
            }
            return GetFacilityFromSite(state.OrganizationServiceProxy, siteLookup);
        }

        public static mcs_facility GetFacility(CancelAppointmentStateObject state, Side side)
        {
            EntityReference siteLookup;
            if (side == Side.Provider)
            {
                if (state.AppointmentType != AppointmentType.STORE_FORWARD)
                    siteLookup = state.ServiceAppointment.mcs_relatedprovidersite;
                else
                    throw new Exception("No Provider Side Encounter should be booked for a Store/Forward Appointment");
            }
            else
            {
                if (state.AppointmentType == AppointmentType.GROUP)
                    siteLookup = state.CrmAppointment.cvt_Site;
                else if (state.AppointmentType == AppointmentType.HOME_MOBILE)
                    throw new Exception("No Patient Side Encounter should be booked for a Home/Mobile Appointment");
                else
                    siteLookup = state.ServiceAppointment.mcs_relatedsite;
            }
            return GetFacilityFromSite(state.OrganizationServiceProxy, siteLookup);
        }
        



        public static mcs_facility GetFacilityFromSite(IOrganizationService orgService, EntityReference siteLookup)
        {
            using (var srv = new Xrm(orgService))
            {
                var facility = (from f in srv.mcs_facilitySet
                                join s in srv.mcs_siteSet
                                on f.Id equals s.mcs_FacilityId.Id
                                where s.Id == siteLookup.Id
                                select f).FirstOrDefault();
                return facility;
            }
        }

        public static string GetProviderName(MakeGroupAppointmentStateObject state)
        {
            return GetProviderName(state.UserId, state.OrganizationServiceProxy);
        }

        public static string GetProviderName(MakeAppointmentStateObject state)
        {
            return GetProviderName(state.UserId, state.OrganizationServiceProxy);
        }

        public static string GetProviderName(CancelAppointmentStateObject state)
        {
            return GetProviderName(state.UserId, state.OrganizationServiceProxy);
        }

        public static string GetProviderName(CancelGroupAppointmentStateObject state)
        {
            return GetProviderName(state.UserId, state.OrganizationServiceProxy);
        }
        
        public static string GetProviderName(Guid userId, IOrganizationService orgService)
        {
            var user = orgService.Retrieve(SystemUser.EntityLogicalName, userId, new ColumnSet(true));
            return user.ToEntity<SystemUser>()?.FullName ?? string.Empty;
        }

        public static Guid GetPatId(MakeAppointmentStateObject state)
        {
            var patId = state.MakeAppointmentRequestMessage.AddedPatients.FirstOrDefault();
            return patId;
        }

        public static Guid GetPatId(CancelAppointmentStateObject state)
        {
            var patId = state.CancelAppointmentRequest.CanceledPatients.FirstOrDefault();
            return patId;
        }


        public static String GetPatientICN(Guid patId,IOrganizationService service, Guid AppointmentId)
        {
            var personIdentifier = new mcs_personidentifiers();
            if (patId == null || patId == Guid.Empty)
                throw new Exception("Patient Cannot be null");
            using (var srv = new Xrm(service))
            {
                personIdentifier = srv.mcs_personidentifiersSet.FirstOrDefault(x => x.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI && x.mcs_assigningauthority == "USVHA" && x.mcs_patient.Id == patId);
            }
            if (personIdentifier == null)
                throw new Exception("Patient has no ICN: " + patId + " - SA/ApptId = " + AppointmentId);
            return personIdentifier.mcs_identifier;
        }

        public static string GetPatientICN(MakeGroupAppointmentStateObject state)
        {
            return GetPatientICN(state.MakeGroupAppointmentRequestMessage.AddedPatients.FirstOrDefault(), state.OrganizationServiceProxy, state.AppointmentId);
        }

        public static string GetPatientICN(MakeAppointmentStateObject state)
        {
            return GetPatientICN(state.MakeAppointmentRequestMessage.AddedPatients.FirstOrDefault(), state.OrganizationServiceProxy, state.AppointmentId);
        }

        public static string GetPatientICN(CancelAppointmentStateObject state)
        {
            return GetPatientICN(state.CancelAppointmentRequest.CanceledPatients.FirstOrDefault(), state.OrganizationServiceProxy, state.AppointmentId);
        }

        public static string GetPatientICN(CancelGroupAppointmentStateObject state)
        {
            return GetPatientICN(state.CancelGroupAppointmentRequest.CanceledPatients.FirstOrDefault(), state.OrganizationServiceProxy, state.AppointmentId);
        }

        public static QueryBeanSecuritySettings GetSecuritySettings(IOrganizationService orgService)
        {
            QueryBeanSecuritySettings settings = new QueryBeanSecuritySettings();
            using (var srv = new Xrm(orgService))
            {
                var errorString = string.Empty;
                var reqAppString = "VIA Requesting App";
                var consAppString = "VIA Consuming App Token";
                var consPassString = "VIA Consuming App Password";
                var ViaSettings = srv.mcs_integrationsettingSet.Where(s => s.mcs_name.Contains("VIA")).ToList();
                var RequestingAppRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == reqAppString);
                var ConsumingAppRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == consAppString);
                var ConsumingAppPasswordRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == consPassString);

                if (RequestingAppRecord == null || string.IsNullOrEmpty(RequestingAppRecord.mcs_value))
                    errorString += reqAppString;
                if (ConsumingAppRecord == null || string.IsNullOrEmpty(ConsumingAppRecord.mcs_value))
                    errorString += string.IsNullOrEmpty(errorString) ? consAppString : ", " + consAppString;
                if (ConsumingAppPasswordRecord == null || string.IsNullOrEmpty(ConsumingAppPasswordRecord.mcs_value))
                    errorString += string.IsNullOrEmpty(errorString) ? consPassString : ", " + consPassString;
                if (!string.IsNullOrEmpty(errorString))
                    throw new Exception(string.Format("No {0} Setting was found, unable to process Vista Request", errorString));

                settings.RequestingApp = RequestingAppRecord.mcs_value;
                settings.ConsumingAppToken = ConsumingAppRecord.mcs_value;
                settings.ConsumingAppPassword = ConsumingAppPasswordRecord.mcs_value;
            }
            return settings;
        }

    }


}
