﻿using System;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class MakeAppointmentMapper
    {
        public VIMTVIASchdMakeApptmakeAppointmentRequest MapMakeAppointmentRequest(MakeGroupAppointmentStateObject state, Side side)
        {
            var clinic = side == Side.Patient ? state.PatClinic : state.ProClinic;
            var facility = side == Side.Patient ? state.PatFacility : state.ProFacility;
            var localDateTime = PipelineUtilities.ConvertUtcToLocal(facility, state.ServiceAppointment.ScheduledStart.Value);
            //5 minute offset for provider side when appt is clinic based
            if (side == Side.Provider && (state.AppointmentType == AppointmentType.CLINIC_BASED || state.AppointmentType == AppointmentType.GROUP))
                localDateTime = localDateTime.AddMinutes(5);

            var apptReqInfo = new VIMTVIASchdMakeApptReqappointment
            {
                mcs_clinicId = clinic.cvt_ien,
                mcs_appointmentLength = state.ServiceAppointment.ScheduledDurationMinutes.ToString(),
                mcs_purpose = state.VistaAppointmentPurpose,
                mcs_timestamp = localDateTime.ToString("yyyyMMdd.HHmm").TrimEnd('0'),
                mcs_appointmentType = state.VistaAppointmentType,
                mcs_lvl = "1" // allows patient to be booked more than 1 time per day
            };
            if (string.IsNullOrEmpty(apptReqInfo.mcs_clinicId))
                throw new Exception(string.Format("Vista Clinic on {0} does not have an IEN.  Not able to be booked to Vista.  Please add the IEN and try again.", side.ToString()));

            return new VIMTVIASchdMakeApptmakeAppointmentRequest
            {
                UserId = state.UserId,
                OrganizationName = state.OrganizationName,
                VIMTVIASchdMakeApptReqappointmentInfo = apptReqInfo,
                VIMTVIASchdMakeApptReqqueryBeanInfo = VistaMapperHelper.GetQueryBean(state, side),
                Debug = true,
                LogSoap = true
            };
        }

        public VIMTVIASchdMakeApptmakeAppointmentRequest MapMakeAppointmentRequest(MakeAppointmentStateObject state, Side side)
        {
            var facility = side == Side.Patient ? state.PatFacility : state.ProFacility;
            var localDateTime = PipelineUtilities.ConvertUtcToLocal(facility, state.ServiceAppointment.ScheduledStart.Value);
            //5 minute offset for provider side when appt is clinic based
            if (side == Side.Provider && (state.AppointmentType == AppointmentType.CLINIC_BASED || state.AppointmentType == AppointmentType.GROUP))
                localDateTime = localDateTime.AddMinutes(5);

            var apptReqInfo = new VIMTVIASchdMakeApptReqappointment
            {
                mcs_clinicId = side == Side.Patient ? state.PatClinic.cvt_ien : state.ProClinic.cvt_ien,
                mcs_appointmentLength = state.ServiceAppointment.ScheduledDurationMinutes.ToString(),
                mcs_purpose = state.VistaAppointmentPurpose,
                mcs_timestamp = localDateTime.ToString("yyyyMMdd.HHmm").TrimEnd('0'),
                mcs_appointmentType = state.VistaAppointmentType,
                mcs_consultIen = side == Side.Patient ? state.ServiceAppointment.cvt_PatConsultIen : state.ServiceAppointment.cvt_ProConsultIen,
                mcs_lvl = "1" // allows patient to be booked more than 1 time per day
            };
            if (string.IsNullOrEmpty(apptReqInfo.mcs_clinicId))
                throw new Exception(string.Format("Vista Clinic on {0} does not have an IEN.  Not able to be booked to Vista.  Please add the IEN and try again.", side.ToString()));

            return new VIMTVIASchdMakeApptmakeAppointmentRequest
            {
                UserId = state.UserId,
                OrganizationName = state.OrganizationName,
                VIMTVIASchdMakeApptReqappointmentInfo = apptReqInfo,
                VIMTVIASchdMakeApptReqqueryBeanInfo = VistaMapperHelper.GetQueryBean(state, side),
                Debug = true,
                LogSoap = true
            };
        }

    }

}
