﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VIMT.VIASchedulingService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class LoginMapper
    {
        public VIMTVIAScheLIloginVIARequest GetLoginRequest(Guid userId, string siteCode, IOrganizationService orgService, string SAMLToken)
        {
            var queryBeanSecuritySettings = VistaMapperHelper.GetSecuritySettings(orgService);
            return new VIMTVIAScheLIloginVIARequest
            {
                UserId = userId,
                mcs_sitecode = siteCode,
                //mcs_accesscode = GetUserAccessCode(userId, siteCode, orgService), //Unnecessary when using SAML Tokens
                //mcs_verifycode = GetUserVerifyCode(userId, siteCode, orgService), //Unnecessary when using SAML Tokens
                VIMTVIAScheLIReqqueryBeanInfo = new VIMTVIAScheLIReqqueryBean
                {
                    mcs_requestingApp = queryBeanSecuritySettings.RequestingApp,
                    mcs_consumingAppToken = queryBeanSecuritySettings.ConsumingAppToken,
                    mcs_consumingAppPassword = queryBeanSecuritySettings.ConsumingAppPassword,
                    mcs_criteria = SAMLToken
                },
                Debug = true,
                LogSoap = true
            };
        }
    }
}