﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;


namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class GetConsultsforPatientMapper
    {
        public VIMTVIAEMRgcfpgetConsultsForPatientRequest mapGetConsultRequest(GetConsultsForPatientStateObject state, Side side,log4net.ILog logger)
        {
            string _localPid = string.Empty;
            var _mpiPid = string.Empty;
            string _providername = string.Empty;
            var stationNumber = side == Side.Patient ? state.PatientStationCode : state.ProviderStationCode;
            using (var _service = new Xrm(state.OrganizationServiceProxy))
            {
                var _patientId = state.GetConsultsRequest.PatientIds.FirstOrDefault();
                var Icn = _service.mcs_personidentifiersSet.FirstOrDefault(i => i.mcs_patient.Id == _patientId && i.mcs_assigningauthority == "USVHA" && i.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI);
                if (Icn == null) { throw new Exception("Icn Could Not Be Retrieved from CRM: " + _patientId); }

                _mpiPid = Icn.mcs_identifier;

                var patientIdentifier = _service.mcs_personidentifiersSet.FirstOrDefault(i => i.mcs_patient.Id == _patientId && i.mcs_assigningfacility == stationNumber && i.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.ParticipantIdentifier_PI);
                if (patientIdentifier == null)
                {
                    Logger.Instance.Debug(string.Format("Vista - No patient identifier found for station code: {0} for patient: {1}", stationNumber, _mpiPid));
                    return null;
                }
                _localPid = patientIdentifier.mcs_identifier;
            }

            var queryBeanAppSettings = VistaMapperHelper.GetSecuritySettings(state.OrganizationServiceProxy);

            return new VIMTVIAEMRgcfpgetConsultsForPatientRequest
            {
                OrganizationName=state.OrganizationName,
                VIMTVIAEMRgcfpReqqueryBeanInfo = new VIMTVIAEMRgcfpReqqueryBean
                {
                    mcs_requestingApp = queryBeanAppSettings.RequestingApp,
                    mcs_status = state.mcs_status,
                    mcs_multiSiteQuery = false,
                    mcs_consumingAppToken = queryBeanAppSettings.ConsumingAppToken,
                    mcs_consumingAppPassword = queryBeanAppSettings.ConsumingAppPassword,
                    VIMTVIAEMRgcfpReqproviderInfo = new VIMTVIAEMRgcfpReqprovider
                    {
                        //mcs_userId = DUZ is set in login step
                        //mcs_name = _providername, //Commenting out - Won't have provider name at this point
                        mcs_loginSiteCode = stationNumber
                    },
                    VIMTVIAEMRgcfpReqpatientInfo = new VIMTVIAEMRgcfpReqpatient
                    {
                        mcs_localPid = _localPid,
                        mcs_localSiteId = stationNumber,
                        mcs_mpiPid = _mpiPid,
                        mcs_vistaLocations = stationNumber
                    }
                }
            };
        }
        
        public GetConsultsForPatientRespTaggedConsultArrays MapEcToLob(VIMTVIAEMRgcfpgetConsultsForPatientResponse ecResponse)
        {
            if (ecResponse == null) return null;
            if (ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo == null) { throw new Exception("EcResponse does not contain data."); }
            var _arrPatientRespArraysInfo = ArrPatientRespArray(ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.VIMTVIAEMRgcfparraysInfo);

            return new GetConsultsForPatientRespTaggedConsultArrays
            {
                Count = ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.mcs_count,
                CountSpecified = ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.mcs_countSpecified,
                GetConsultsForPatientRespArraysInfo = _arrPatientRespArraysInfo
            };
        }

        public GetConsultsForPatientRespArraysMultipleResponse[] ArrPatientRespArray(VIMTVIAEMRgcfparraysMultipleResponse[] ecResponseItem)
        {
            var _tempList = new List<GetConsultsForPatientRespArraysMultipleResponse>();

            foreach (var i in ecResponseItem)
            {
                var _innerList = new List<GetConsultsForPatientRespConsultsMultipleResponse>();
                var faultObj = i.VIMTVIAEMRgcfpfault23Info;
                if (i.VIMTVIAEMRgcfpconsultsInfo != null)
                {
                    foreach (var j in i.VIMTVIAEMRgcfpconsultsInfo)
                    {
                        var _locConsult = new GetConsultsForPatientRespConsultsMultipleResponse
                        {
                            Title = j.mcs_title,
                            RequestedProcedure = j.mcs_requestedProcedure,
                            ConsultIen = j.mcs_consultIen,
                            RequestDate = j.mcs_requestDate,
                            ServiceIen = j.mcs_serviceIen,
                            ServiceName = j.mcs_serviceName,
                            PatientDfn = j.mcs_patientDfn,
                            PatientName = j.mcs_patientName,
                            SendingProviderDuz = j.mcs_sendingProviderDuz,
                            SendingProviderName = j.mcs_sendingProviderName,
                            ProvisionalDiagnosis = j.mcs_provisionalDiagnosis,
                            Id = j.mcs_id,
                            Timestamp = j.mcs_timestamp,
                            OrderingServiceName = j.mcs_orderingServiceName,
                            TreatingSpecialty = j.mcs_treatingSpecialty,
                            StartDate = j.mcs_startDate,
                            StopDate = j.mcs_stopDate,
                            Status = j.mcs_status,
                            DateSigned = j.mcs_dateSigned,
                            VerifyingNurse = j.mcs_verifyingNurse,
                            VerifyingClerk = j.mcs_verifyingClerk,
                            DateVerified = j.mcs_dateVerified,
                            ChartReviewer = j.mcs_chartReviewer,
                            DateReviewed = j.mcs_dateReviewed,
                            Text = Base64Encode(j.mcs_text),
                            Detail = j.mcs_detail,
                            ErrMsg = j.mcs_errMsg,
                            Flag = j.mcs_flag,
                            FlagSpecified = j.mcs_flagSpecified
                        };

                        _innerList.Add(_locConsult);
                    }
                }
                var resp = new GetConsultsForPatientRespArraysMultipleResponse
                {
                    Tag = i.mcs_tag,
                    Count = i.mcs_count,
                    CountSpecified = i.mcs_countSpecified,
                    GetConsultsForPatientRespConsultsInfo = _innerList.ToArray()
                };
                if (faultObj != null)
                    resp.GetConsultsForPatientRespFault23Info = new GetConsultsForPatientRespFault23
                    {
                        InnerMessage = faultObj?.mcs_innerMessage,
                        InnerStackTrace = faultObj?.mcs_innerStackTrace,
                        InnerType = faultObj?.mcs_innerType,
                        Message = faultObj?.mcs_message,
                        StackTrace = faultObj?.mcs_stackTrace,
                        Suggestion = faultObj?.mcs_suggestion,
                        Type = faultObj?.mcs_type
                    };
                _tempList.Add(resp);
            }
            return _tempList.ToArray();

        }

        //Used twice, so maybe move to a common area
        private static string Base64Encode(string plainText)
        {
            var plainTextBytes = Encoding.UTF8.GetBytes(plainText);
            return Convert.ToBase64String(plainTextBytes);
        }
    }
}
