﻿using System;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VRM.Integration.Servicebus.Core;
using VA.TMP.OptionSets;
using VIMT.VIASchedulingService.Messages;
using Microsoft.Xrm.Sdk;

namespace VA.TMP.Integration.VIMT.Vista.Links
{
    class VistaSchedulingUtilities
    {
        #region EC to LOB Mappers
        public static VistaAppointment MapCancelAppointmentEcToLob(Side side, VIMTVIASchedCancApcancelAppointmentResponse response, VIMTVIASchedCancApcancelAppointmentRequest request, Guid serviceAppointmentId, Guid appointmentId, mcs_facility facility, mcs_resource clinic)
        {
            if (request == null || response?.VIMTVIASchedCancApcancelAppointmentTOInfo == null)
                return null;

            var _faultObj = response.VIMTVIASchedCancApcancelAppointmentTOInfo.VIMTVIASchedCancApfault16Info;

            if (response.ExceptionOccured)
                _faultObj = new VIMTVIASchedCancApfault16 { mcs_message = response.ExceptionMessage };

            var Appt = new VistaAppointment
            {
                CancelCode = CancelAppointmentMapper.MapCancelCodeToTmp(request.VIMTVIASchedCancApReqappointmentInfo.mcs_cancelCode),
                CancelReason = CancelAppointmentMapper.MapCancelReasonToTmp(request.VIMTVIASchedCancApReqappointmentInfo.mcs_cancelReason),
                CancelRemarks = request.VIMTVIASchedCancApReqappointmentInfo.mcs_remarks,
                ClinicIen = response.VIMTVIASchedCancApcancelAppointmentTOInfo.VIMTVIASchedCancApclinicInfo?.mcs_id ?? clinic.cvt_ien,
                ClinicName = response.VIMTVIASchedCancApcancelAppointmentTOInfo.VIMTVIASchedCancApclinicInfo?.mcs_name ?? clinic.mcs_name,
                Duration = request.VIMTVIASchedCancApReqappointmentInfo.mcs_appointmentLength,
                FacilityStationCode = request.VIMTVIASchedCancApReqappointmentInfo.VIMTVIASchedCancApReqfacilityInfo?.mcs_id ?? facility.mcs_StationNumber,
                LocalStartTime = response.VIMTVIASchedCancApcancelAppointmentTOInfo.mcs_timestamp,
                PatientIcn = request.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqpatientInfo.mcs_mpiPid,
                PatientName = new PersonName
                {
                    LastName = request.VIMTVIASchedCancApReqqueryBeanInfo.VIMTVIASchedCancApReqpatientInfo.mcs_name
                },
                ServiceAppointmentId = serviceAppointmentId,
                FacilityName = response.VIMTVIASchedCancApcancelAppointmentTOInfo.VIMTVIASchedCancApclinicInfo?.VIMTVIASchedCancApfacilityInfo?.mcs_name ?? facility.mcs_name,
                Status = _faultObj == null ? VistaAppointmentStatus.CANCELLED : VistaAppointmentStatus.FAILED_TO_CANCEL,
                ErrorMessage = _faultObj == null ? string.Empty : _faultObj.mcs_message
            };
            if (appointmentId != Guid.Empty)
                Appt.AppointmentId = appointmentId;
            return Appt;
        }

        public static VistaAppointment MapApptEcToLob(Side side, VIMTVIASchdMakeApptmakeAppointmentRequest request, VIMTVIASchdMakeApptmakeAppointmentResponse response, Guid saId, Guid apptId, mcs_resource clinic, mcs_facility facility)
        {
            if (request == null || response == null)
                return null;
            var faultObj = response.VIMTVIASchdMakeApptappointmentTOInfo?.VIMTVIASchdMakeApptfault17Info;
            if (response.ExceptionOccured)
                faultObj = new VIMTVIASchdMakeApptfault17 { mcs_message = response.ExceptionMessage };
            var Appt = new VistaAppointment
            {
                ClinicIen = clinic?.cvt_ien,
                ClinicName = clinic?.mcs_name,
                Duration = response.VIMTVIASchdMakeApptappointmentTOInfo?.mcs_appointmentLength,
                ErrorMessage = (faultObj != null) ? faultObj.mcs_message : "",
                FacilityName = facility?.mcs_name,
                FacilityStationCode = facility?.mcs_StationNumber,
                LocalStartTime = response.VIMTVIASchdMakeApptappointmentTOInfo?.mcs_timestamp,
                PatientIcn = request.VIMTVIASchdMakeApptReqqueryBeanInfo?.VIMTVIASchdMakeApptReqpatientInfo?.mcs_mpiPid,
                PatientName = new PersonName { LastName = request.VIMTVIASchdMakeApptReqqueryBeanInfo?.VIMTVIASchdMakeApptReqpatientInfo?.mcs_name },
                ServiceAppointmentId = saId,
                Status = (faultObj != null) ? VistaAppointmentStatus.FAILED_TO_RECEIVE: VistaAppointmentStatus.RECEIVED
            };
            if (apptId != Guid.Empty)
                Appt.AppointmentId = apptId;
            return Appt;
        }

        #endregion

        #region Clinic Helpers
        private static string GetClinicName(VIMTVIASchdMakeApptReqappointment request, MakeGroupAppointmentStateObject state, Side side)
        {
            var name = request.VIMTVIASchdMakeApptReqclinicInfo?.mcs_name;
            if (!string.IsNullOrEmpty(name))
                return name;
            return (side == Side.Patient) ? state.PatClinic.mcs_name : state.ProClinic.mcs_name;
        }

        public static mcs_resource GetClinic(Side side, IOrganizationService organizationService, ServiceAppointment serviceAppointment, Appointment appointment, bool isGroup)
        {
            using (var srv = new Xrm(organizationService))
            {
                var bookedResources = serviceAppointment.Resources.Where(r => r.PartyId.LogicalName == "equipment").ToList();
                if (appointment != null && appointment.RequiredAttendees != null  && side == Side.Patient && isGroup)
                {
                    bookedResources.AddRange(appointment.RequiredAttendees.Where(r => r.PartyId.LogicalName == "equipment").ToList());
                }
                var clinicIen = string.Empty;
                foreach (var equipmentParty in bookedResources)
                {
                    var resource = srv.mcs_resourceSet.FirstOrDefault(r => r.mcs_relatedResourceId != null && r.mcs_relatedResourceId.Id == equipmentParty.PartyId.Id);
                    if (resource?.mcs_Type != null && resource.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic)
                    {
                        //Ensure that the VistA Clinic retrieved is the one for the appropriate site, otherwise skip to the next one
                        if (side == Side.Patient)
                        {
                            if (!isGroup && serviceAppointment.mcs_relatedsite != null)
                            {
                                if (serviceAppointment.mcs_relatedsite.Id == resource.mcs_RelatedSiteId.Id)
                                    return resource;
                                else
                                    Logger.Instance.Debug("Vista Clinic Site doesnt match Patient Site, looking for next Vista Clinic: " + resource.mcs_name);
                            }
                            else if (isGroup && appointment.cvt_Site != null)
                            {
                                if (appointment.cvt_Site.Id == resource.mcs_RelatedSiteId.Id)
                                    return resource;
                                else
                                    Logger.Instance.Debug("Vista Clinic Site doesnt match Patient Site, looking for next Vista Clinic: " + resource.mcs_name);
                            }
                            else
                                throw new Exception("No Patient Site is listed");
                        }
                        else
                        {
                            if (serviceAppointment.mcs_relatedprovidersite != null)
                            {
                                if (serviceAppointment.mcs_relatedprovidersite.Id == resource.mcs_RelatedSiteId.Id)
                                    return resource;
                                else
                                    Logger.Instance.Debug("Vista Clinic Site doesn't match Provider Site, looking for next Vista Clinic: " + resource.mcs_name);
                            }
                            else
                                throw new Exception("No Provider Site is listed");
                        }

                    }
                }
                throw new Exception(string.Format("No Valid Vista Clinics were found for the {0} side", side.ToString()));
            }
        }
#endregion

        #region Over Loads
        public static mcs_resource GetClinic(MakeGroupAppointmentStateObject state, Side side)
        {
            return GetClinic(side, state.OrganizationServiceProxy, state.ServiceAppointment, state.CrmAppointment, true);
        }
        public static mcs_resource GetClinic(MakeAppointmentStateObject state, Side side)
        {
            return GetClinic(side, state.OrganizationServiceProxy, state.ServiceAppointment, state.CrmAppointment, false);
        }
        public static mcs_resource GetClinic(CancelGroupAppointmentStateObject state, Side side)
        {
            return GetClinic(side, state.OrganizationServiceProxy, state.ServiceAppointment, state.CrmAppointment, true);
        }
        public static mcs_resource GetClinic(CancelAppointmentStateObject state, Side side)
        {
            return GetClinic(side, state.OrganizationServiceProxy, state.ServiceAppointment, state.CrmAppointment, false); 
        }


        public static VistaAppointment MapAppointmentEcToLob(Side side, MakeAppointmentStateObject state, log4net.ILog logger)
        {
            if (side == Side.Patient)
                return MapApptEcToLob(side, state.PatEcRequest, state.PatEcResponse, state.ServiceAppointment.Id, Guid.Empty, state.PatClinic, state.PatFacility);
            else
                return MapApptEcToLob(side, state.ProEcRequest, state.ProEcResponse, state.ServiceAppointment.Id, Guid.Empty, state.ProClinic, state.ProFacility);
        }

        public static VistaAppointment MapGroupAppointmentEcToLob(Side side, MakeGroupAppointmentStateObject state, log4net.ILog logger)
        {
            var patientId = state.MakeGroupAppointmentRequestMessage.AddedPatients.FirstOrDefault();
            if (side == Side.Patient)
                return MapApptEcToLob(side, state.PatEcRequest, state.PatEcResponse, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.PatClinic, state.PatFacility);
            else
                return MapApptEcToLob(side, state.ProEcRequest, state.ProEcResponse, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.ProClinic, state.ProFacility);
        }
        #endregion
    }
}
