﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.Links
{
    public static class VistaFakeResponses
    {
        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakeAppointmentSuccessResponse(VIMTVIASchdMakeApptmakeAppointmentRequest request, string fakeType)
        {
            if (fakeType == "0")
            {
                return new VIMTVIASchdMakeApptmakeAppointmentResponse
                {
                    VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                    {
                        mcs_appointmentLength = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentLength,
                        mcs_appointmentType = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentType,
                        mcs_bookNotes = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_bookNotes,
                        mcs_clinicId = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                        mcs_consultIen = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_consultIen,
                        mcs_currentStatus = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_currentStatus,
                        mcs_providerName = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_providerName,
                        mcs_purpose = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_purpose,
                        mcs_timestamp = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_timestamp,
                        VIMTVIASchdMakeApptclinicInfo = new VIMTVIASchdMakeApptclinic
                        {
                            mcs_id = request.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                            mcs_askForCheckInSpecified = false
                        }
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
            }
            else
            {
                return new VIMTVIASchdMakeApptmakeAppointmentResponse
                {
                    VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                    {
                        VIMTVIASchdMakeApptfault17Info = new VIMTVIASchdMakeApptfault17
                        {
                            mcs_message = "Fake Failure Error: Invalid Appointment: Result(0)=APTNOST^NO OPEN SLOTS THEN^1"
                        }
                    },
                    ExceptionOccured = true
                };
            }
        }
        
        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakePatAppointmentSuccessResponse(MakeAppointmentStateObject state)
        {
            if (state.PatEcRequest != null && state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo != null && state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo != null)
                return new VIMTVIASchdMakeApptmakeAppointmentResponse
                {
                    VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                    {
                        mcs_appointmentLength = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentLength,
                        mcs_appointmentType = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentType,
                        mcs_bookNotes = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_bookNotes,
                        mcs_clinicId = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                        mcs_consultIen = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_consultIen,
                        mcs_currentStatus = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_currentStatus,
                        mcs_providerName = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_providerName,
                        mcs_purpose = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_purpose,
                        mcs_timestamp = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_timestamp,
                        VIMTVIASchdMakeApptclinicInfo = new VIMTVIASchdMakeApptclinic
                        {
                            mcs_id = state.PatEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                            mcs_askForCheckInSpecified = false
                        }
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
            else
                return null;
        }

        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakeProAppointmentSuccessResponse(MakeAppointmentStateObject state)
        {
            if (state.ProEcRequest != null && state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo != null && state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo != null)
                return new VIMTVIASchdMakeApptmakeAppointmentResponse
                {
                    VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                    {
                        mcs_appointmentLength = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentLength,
                        mcs_appointmentType = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_appointmentType,
                        mcs_bookNotes = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_bookNotes,
                        mcs_clinicId = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                        mcs_consultIen = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_consultIen,
                        mcs_currentStatus = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_currentStatus,
                        mcs_providerName = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_providerName,
                        mcs_purpose = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_purpose,
                        mcs_timestamp = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_timestamp,
                        VIMTVIASchdMakeApptclinicInfo = new VIMTVIASchdMakeApptclinic
                        {
                            mcs_id = state.ProEcRequest.VIMTVIASchdMakeApptReqappointmentInfo.mcs_clinicId,
                            mcs_askForCheckInSpecified = false
                        }
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
            else
                return null;
        }

        public static VIMTVIASchedCancApcancelAppointmentResponse FakeCancelAppointmentSuccessResponse(VIMTVIASchedCancApcancelAppointmentRequest request)
        {
            if (request != null && request.VIMTVIASchedCancApReqappointmentInfo != null && request.VIMTVIASchedCancApReqqueryBeanInfo != null)
            {
                return new VIMTVIASchedCancApcancelAppointmentResponse
                {
                    VIMTVIASchedCancApcancelAppointmentTOInfo = new VIMTVIASchedCancApcancelAppointmentTO
                    {
                        mcs_purpose = request.VIMTVIASchedCancApReqappointmentInfo.mcs_purpose,
                        mcs_reason = request.VIMTVIASchedCancApReqappointmentInfo.mcs_cancelReason, //
                        mcs_remarks = request.VIMTVIASchedCancApReqappointmentInfo.mcs_remarks,
                        mcs_timestamp = request.VIMTVIASchedCancApReqappointmentInfo.mcs_timestamp,
                        VIMTVIASchedCancApclinicInfo = new VIMTVIASchedCancApclinic
                        {
                            mcs_id = request.VIMTVIASchedCancApReqappointmentInfo.mcs_clinicId,
                            mcs_askForCheckInSpecified = false
                        }
                    },
                    ExceptionOccured = false,
                    MessageId = new Guid().ToString()
                };
            }
            else
                return null;
        }

        public static VIMTVIASchedCancApcancelAppointmentResponse FakeCancelAppointmentResponse(string fakeType, VIMTVIASchedCancApcancelAppointmentRequest request)
        {
            if (request != null && request.VIMTVIASchedCancApReqappointmentInfo != null && request.VIMTVIASchedCancApReqqueryBeanInfo != null)
            {
                if (fakeType == "0")
                {
                    return new VIMTVIASchedCancApcancelAppointmentResponse
                    {
                        VIMTVIASchedCancApcancelAppointmentTOInfo = new VIMTVIASchedCancApcancelAppointmentTO
                        {
                            mcs_purpose = request.VIMTVIASchedCancApReqappointmentInfo.mcs_purpose,
                            mcs_reason = request.VIMTVIASchedCancApReqappointmentInfo.mcs_cancelReason, //
                            mcs_remarks = request.VIMTVIASchedCancApReqappointmentInfo.mcs_remarks,
                            mcs_timestamp = request.VIMTVIASchedCancApReqappointmentInfo.mcs_timestamp,
                            VIMTVIASchedCancApclinicInfo = new VIMTVIASchedCancApclinic
                            {
                                mcs_id = request.VIMTVIASchedCancApReqappointmentInfo.mcs_clinicId,
                                mcs_askForCheckInSpecified = false
                            }
                        },
                        ExceptionOccured = false,
                        MessageId = new Guid().ToString()
                    };
                }
                else
                    return new VIMTVIASchedCancApcancelAppointmentResponse
                    {
                        VIMTVIASchedCancApcancelAppointmentTOInfo = new VIMTVIASchedCancApcancelAppointmentTO
                        {
                            VIMTVIASchedCancApfault16Info = new VIMTVIASchedCancApfault16
                            {
                                mcs_message = "appointment.cancelCode cannot be empty, appointment.cancelReason cannot be empty"
                            }
                        },
                        MessageId = new Guid().ToString(),
                        ExceptionOccured = false
                    };
            }
            else
                return null;
        }

        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakeProAppointmentFailureResponse1(MakeAppointmentStateObject state, string message= "***FAKE ERROR*** Invalid appointment: RESULT(0)=APTNOST^NO OPEN SLOTS THEN^1")
        {

            return new VIMTVIASchdMakeApptmakeAppointmentResponse
            {
                VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                {
                    VIMTVIASchdMakeApptfault17Info = new VIMTVIASchdMakeApptfault17
                    {
                        mcs_message = message
                    }
                },
                ExceptionOccured = false
            };
        }

        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakeProAppointmentFailureResponse2(MakeAppointmentStateObject state, string message = "FAKE ERROR**** Invalid appointment: RESULT(0) = APTPHSD ^ PATIENT ALREADY HAS APPOINTMENT ON THE SAME DAY(AT 11:00) ^ 3")
        {
            return new VIMTVIASchdMakeApptmakeAppointmentResponse
            {
                VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                {
                    VIMTVIASchdMakeApptfault17Info = new VIMTVIASchdMakeApptfault17
                    {
                        mcs_message = message
                    }
                },
                ExceptionOccured = false
            };
        }

        public static VIMTVIASchdMakeApptmakeAppointmentResponse FakeMakeProAppointmentFailureResponse3(MakeAppointmentStateObject state, string message = "FAKE ERROR**** Unexpected Exception Exception encountered in ReadWork processing site: 516. Original Exception Message: Unable to execute RPC : Exception occurred executing transfer, destroying connection\\;    Root cause exception:  gov.va.med.net.VistaSocketException: Error occurred reading from socket. \\;  Root cause exception:	gov.va.med.net.VistaSocketException: End of stream encountered unexpectedly.")
        {
            return new VIMTVIASchdMakeApptmakeAppointmentResponse
            {
                VIMTVIASchdMakeApptappointmentTOInfo = new VIMTVIASchdMakeApptappointmentTO
                {
                    VIMTVIASchdMakeApptfault17Info = new VIMTVIASchdMakeApptfault17
                    {
                        mcs_message = message
                    }
                },
                ExceptionOccured = false
            };
        }

        public static VIMTVIAEMRgcfpgetConsultsForPatientResponse FakegcfpGetConsultsForPatientResponse(GetConsultsForPatientStateObject state, string message = "VIA Security Exception: Consuming Application credentials received are not valid. Please verify the credentials.If you need assistance, please contact the VIA Support Team.")
        {
            return new VIMTVIAEMRgcfpgetConsultsForPatientResponse
            {
            };
        }

        public static VIMTVIAEMRgcfpgetConsultsForPatientResponse FakeGetConsultsForPatientSuccess()
        {
            return new VIMTVIAEMRgcfpgetConsultsForPatientResponse
            {
                VIMTVIAEMRgcfptaggedConsultArraysInfo = new VIMTVIAEMRgcfptaggedConsultArrays
                {
                    mcs_count = 1,
                    mcs_countSpecified = true,
                    VIMTVIAEMRgcfparraysInfo = new VIMTVIAEMRgcfparraysMultipleResponse[]
                    {
                       new VIMTVIAEMRgcfparraysMultipleResponse
                       {
                           mcs_tag= "516",
                           mcs_count=91,
                           mcs_countSpecified=true,
                           VIMTVIAEMRgcfpfault23Info=new VIMTVIAEMRgcfpfault23 {
                                
                           },
                           VIMTVIAEMRgcfpconsultsInfo = new VIMTVIAEMRgcfpconsultsMultipleResponse[]
                           {
                               new VIMTVIAEMRgcfpconsultsMultipleResponse
                               {
                                   mcs_title="COLONOSCOPY CP COLONOSCOPY Proc",
                                   mcs_id="480151",
                                   mcs_timestamp="20110209.072223",
                                   mcs_status="Complete",
                                   mcs_text=Base64Encode("Current PC Provider:   CHALMERS, BONITA Current PC Team:       TEAM CHY 4 Current Pat. Status:   Outpatient Primary Eligibility:   NSC(VERIFIED) Patient Type:          NSC VETERAN OEF/OIF:               NO Order Information To Service:            CP COLONOSCOPY From Service:          CHY ENDO PROCEDURE Requesting Provider:   CHALMERS,BONITA Service is to be rendered on an OUTPATIENT basis Place:                 Consultant's choice Urgency:               Routine Clinically Ind. Date:   Orderable Item:        COLONOSCOPY Procedure:             COLONOSCOPY Clinical Procedure:    COLONOSCOPY Reason For Request: (Do not use this to order a Colonoscopy....used for Endoworks equipment only) **see report   Inter-facility Information This is not an inter-facility consult request.  Status:                COMPLETE Last Action:           COMPLETE/UPDATE  Facility  Activity                Date/Time/Zone      Responsible Person  Entered By -------------------------------------------------------------------------------  CPRS RELEASED ORDER     02/09/11 07:22      CHALMERS,BONITA     KRUEGER,CORINNE L  INCOMPLETE RPT          02/09/11 10:26                          SHOLLER,WILMER      Note# 4702953  COMPLETE/UPDATE         02/09/11 10:00      CLINICAL,DEVICE P   SHURMAN,JILLIAN A                (entered) 02/09/11 11:00          Note# 4702953  Note: TIME ZONE is local if not indicated  --------------------------------------------------------------------------------   LOCAL TITLE: CP COLONOSCOPY                                      STANDARD TITLE: GASTROENTEROLOGY PROCEDURE NOTE                  DATE OF NOTE: FEB 09, 2011@10:25:46  ENTRY DATE: FEB 09, 2011@10:25:46             AUTHOR: CLINICAL,DEVICE PRO  EXP COSIGNER:                                 URGENCY:                            STATUS: COMPLETED                       PROCEDURE SUMMARY CODE: Machine Resulted               DATE/TIME PERFORMED: FEB 09, 2011@10:00    ** DOCUMENT IN VISTA IMAGING ** SEE FULL REPORT IN VISTA IMAGING  SIGNATURE NOT REQUIRED SEE SIGNATURE IN VISTA IMAGING  ** (OLYMPUS Colonoscopy)  AUTO-INSTRUMENT DIAGNOSIS **  Procedure: Col  Colonoscopy  Release Status: Released Off-Line Verified Date Verified: Feb 09, 2011@10:11  Indications: Surveillance of prior high grade adenoma (V12.72).   Consent: The benefits, risks, and alternatives to the procedure were  discussed and informed consent was obtained from the patient.   Preparation:  EKG, pulse, pulse oximetry and blood pressure were monitored  throughout the procedure. The patient received PEG in preparation for the  procedure. ASA Classification: Class 3 - Patient has severe systemic  disturbance that may or may not be related to the disorder requiring  surgery.   Medications: Versed 2 mg IV   Rectal Exam: Normal rectal exam.   Procedure:  The endoscope was passed with ease through the anus under  direct visualization and advanced to the cecum, confirmed by appendiceal  orifice and ileocecal valve. The scope was withdrawn and the mucosa was  carefully examined. The quality of the preparation was good. The views  were good. The patient's toleration of the procedure was good.Retroflexion was performed in the rectum.Findings:  There was evidence of diverticulosis in the sigmoid colon.On retroflexed view, internal hemorrhoids were found in the rectum.There  was evidence of prior colectomy in the colon.   Unplanned Events:  There were no unplanned events.Impressions: Diverticulosis (562.10) found in the sigmoid colon.Internal hemorrhoids in the rectum(455.0). Evidence of prior intervention in the colon.Personal history of polyps (V12.72)   Recommendations: Colonoscopy recommended in 5 years.Procedure Codes: 45378: Colonoscopy Version 1, electronically signed by Dr.John Beckman on 02/09/2011 at  10:18.    Administrative Closure: 02/09/2011                     by:                          CP CONSULT PROXY      ================================================================================ ==================================== END ===================================== "),
                                   mcs_flagSpecified=false
                               },
                               new VIMTVIAEMRgcfpconsultsMultipleResponse
                               {
                                   mcs_title="ECHO - OUTPATIENT Cons",
                                   mcs_id="475302",
                                   mcs_timestamp="20110118.093947",
                                   mcs_status="Complete",
                                   mcs_text=Base64Encode("Current PC Provider:   CHALMERS,BONITA Current PC Team:       TEAM CHY 4 Current Pat. Status:   Outpatient Primary Eligibility:   NSC(VERIFIED) Patient Type:          NSC VETERAN OEF/OIF:               NO  Order Information To Service:            ECHO - OUTPATIENT From Service:          CHY CHF CLINIC Requesting Provider:   BARCELLOS,INA Service is to be rendered on an OUTPATIENT basis Place:                 Consultant's choice Urgency:               Routine Clinically Ind. Date:   Orderable Item:        ECHO - OUTPATIENT Consult:               Consult Request Provisional Diagnosis: chf Reason For Request: Reeval EF after pt has been on optimal medication for 3 months...may need  ICD.   Inter-facility Information This is not an inter-facility consult request.  Status:                COMPLETE Last Action:           NEW NOTE ADDED  Facility  Activity                Date/Time/Zone      Responsible Person  Entered By -------------------------------------------------------------------------------  CPRS RELEASED ORDER     01/18/11 09:39      BARCELLOS,INA       BARCELLOS,INA  PRINTED TO R108         01/18/11 09:39                                             SCHEDULED               01/21/11 11:54      BARCELLOS,INA       MCKENDREE,LILIA CHY CPL ECHO II Consult Appt. on 02/08/11 @ 11:30 ltr to pt   STATUS CHANGE           02/07/11 08:48      BARCELLOS,INA       MCKENDREE,LILIA CHY CPL ECHO II Appt. on 02/08/11 @ 11:30 was cancelled by the Patient. Remarks: resched for 020911   SCHEDULED               02/07/11 08:48      BARCELLOS,INA       MCKENDREE,LILIA CHY CPL ECHO II Consult Appt. on 02/09/11 @ 07:30 per lindy   COMPLETE/UPDATE         02/09/11 08:22      WEHE,SONJA L        WEHE,SONJA L      Note# 4702411  NEW NOTE ADDED          02/09/11 13:54      HYDZIK,DAVIS R      HYDZIK,DAVIS R      Note# 4703940  Note: TIME ZONE is local if not indicated  --------------------------------------------------------------------------------   LOCAL TITLE: CARDIOPULMONARY ECHOCARDIOGRAM CONSULT REPORT       STANDARD TITLE: CARDIOLOGY DIAGNOSTIC STUDY CONSULT              DATE OF NOTE: FEB 09, 2011@08:21     ENTRY DATE: FEB 09, 2011@08:21:56             AUTHOR: WEHE,SONJA L         EXP COSIGNER:                                 URGENCY:                            STATUS: COMPLETED                       ECHO completed.   /es/ LINDA L CORRELL LPN/Med Instrument Tech Signed: 02/09/2011 08:22 --------------------------------------------------------------------------------   LOCAL TITLE: CARDIOPULMONARY ECHOCARDIOGRAM CONSULT REPORT       STANDARD TITLE: CARDIOLOGY DIAGNOSTIC STUDY CONSULT              DATE OF NOTE: FEB 09, 2011@13:53     ENTRY DATE: FEB 09, 2011@13:53:12             AUTHOR: HYDZIK,DAVIS R       EXP COSIGNER:                                 URGENCY:                            STATUS: COMPLETED                       I. STUDY INFORMATION   A. Study Type: TRANSTHORACIC CARDIAC ULTRASOUND EXAMINATION   B. Study Date/Time: 02/09/2011  10:28   C. Report Date/Time:  02/09/2011  13:52  II. PATIENT INFORMATION   A. Patient Name (Last, First, Middle):  MONTOYA, JOE A   B. Age:     67 years   C. Height:  65 inches   D. Weight: 158 lbs  III. REQUESTING INFORMATION   A. Procedure Indications: EVALUATE EF AFTER PATIENT HAS BEEN ON       OPTIMAL MEDICATION FOR 3 MONTHS.   B. Requesting Clinician:  SANDRA GUIDRY, MD  IV. CONCLUSIONS   A. Study Quality:    B. Left Ventricle: MILD SYSTOLIC DYSFUNCTION IN A GLOBAL       DISTRIBUTION; NORMAL SIZE; MILD HYPERTROPHY   C. Aortic Valve: NO REGURGITATION;    D. Mitral Valve: NO REGURGITATION;    E. Tricuspid Valve: NO REGURGITATION   F. Pulmonary Hypertension:  NONE   G. Pericardial Effusion:  NONE   H. Other Conclusions     1. LOW NORMAL TO SLIGHTLY REDUCED LV FUNCTION (EF 45-50%) WITH         PARADOXICAL SEPTAL MOTION, LIKELY DUE TO A CONDUCTION ABNORMALITY.         FUNCTION HAS IMPROVED SINCE THE STUDY PERFORMED IN 8/11/2010.     2. NO SIGNIFICANT VALVE DISEASE.     3. IVC DYNAMICS SUGGEST NORMAL CENTRAL VENOUS PRESSURE.  Author:      KATZ, DAVID  Signed by:   GREYSON,CLIFFORD   02/09/2011  00:00                   CARDIAC ULTRASOUND ASSESSMENT DETAILS VI. MEASUREMENTS                              VALUE     NORMAL RANGE   A. LV Internal Dimension (Diastole):          5.0    (4.0 - 5.6 CM)   B. LV Internal Dimension (Systole):           3.6    (2.0 - 3.8 CM)   C. Fractional Shortening (%):                 28.0    (28% - 41%)   D. Septal Thickness (Diastole):               1.2    (0.7 - 1.1 CM)   E. Posterior Wall Thickness (Diastole):       0.7    (0.7 - 1.1 CM)   F. Left Atrial Dimension:                     3.9    (2.5 - 4.0 CM)   G. Aortic Root Dimension:                     3.5    (2.0 - 3.7 CM)   H. Right Ventricular Dimension:               2.1    (0.7 - 2.3 CM)  VII. VALVE ASSESSMENT   A. Aortic Valve     1. Aortic valve regurgitation:        NONE     2. Aortic valve thickening:           NONE     3. Aortic valve motion:               NORMAL     4. Aortic valve mean gradient:      5. Aortic valve peak gradient:      6. Aortic valve orifice area:    B. Mitral Valve     1. Mitral valve regurgitation:        NONE     2. Mitral valve thickening:           NONE     3. Mitral valve motion:               NORMAL     4. Mitral valve mean gradient:      5. Mitral valve orifice area:    C. Tricuspid Valve     1. Tricuspid valve regurgitation:     NONE     2. Tricuspid valve thickening:        NONE     3. Tricuspid valve motion:            NORMAL   D. Pulmonic Valve Regurgitation: PRESENT  IX. OTHER FINDINGS   A. Right Ventricle (RV)     1. RV systolic function:         NORMAL     2. Right ventricular size:       NORMAL   B. Atria     1. Left atrial size:             NORMAL     2. Right atrial size:            NORMAL   C. Pulmonary Artery Pressure:      20 MM HG + RIGHT ATRIAL PRESSURE   D. Pericardium     1. Pericardial thickening:      2. Pericardial effusion:         NONE   E. Other Findings:   X. CARDIAC ULTRASOUND LABORATORY INFORMATION   A. Tape: ; Start: ; End: ; MO:    B. CPT Codes     1. Primary CPT Code:      2. Secondary CPT Code:      3. Tertiary CPT Code:    C. Comments by Sonographer: BP 129/86   /es/ CLIFFORD R. GREYSON, MD STAFF CARDIOLOGIST Signed: 02/09/2011 13:54 ================================================================================ ==================================== END ===================================== "),
                                   mcs_flagSpecified=false
                               }
                           }

                       }

                    }

                }
            };
        }

        private static string Base64Encode(string plainText)
        {
            var plainTextBytes = Encoding.UTF8.GetBytes(plainText);
            return Convert.ToBase64String(plainTextBytes);
        }
        //Response
        //<? xml version = "1.0" ?>
        //< VIMTVIAEMRgcfpgetConsultsForPatientResponse xmlns:xsi= "http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd= "http://www.w3.org/2001/XMLSchema" >
        //  < MessageId > 0a551457-fa95-4a5c-8398-9a026e6343da</MessageId>
        //  <VIMTVIAEMRgcfptaggedConsultArraysInfo>
        //    <mcs_count>1</mcs_count>
        //    <mcs_countSpecified>true</mcs_countSpecified>
        //    <VIMTVIAEMRgcfparraysInfo>
        //      <VIMTVIAEMRgcfparraysMultipleResponse>
        //        <mcs_tag>516</mcs_tag>
        //        <mcs_count>91</mcs_count>
        //        <mcs_countSpecified>true</mcs_countSpecified>
        //        <VIMTVIAEMRgcfpconsultsInfo>
        //          <VIMTVIAEMRgcfpconsultsMultipleResponse>
        //            <mcs_title>COLONOSCOPY CP COLONOSCOPY Proc</mcs_title>
        //            <mcs_id>480151</mcs_id>
        //            <mcs_timestamp>20110209.072223</mcs_timestamp>
        //            <mcs_status>Complete</mcs_status>
        //            <mcs_text>Current PC Provider:   CHALMERS, BONITA Current PC Team:       TEAM CHY 4 Current Pat. Status:   Outpatient Primary Eligibility:   NSC(VERIFIED) Patient Type:          NSC VETERAN OEF/OIF:               NO Order Information To Service:            CP COLONOSCOPY From Service:          CHY ENDO PROCEDURE Requesting Provider:   CHALMERS,BONITA Service is to be rendered on an OUTPATIENT basis Place:                 Consultant's choice Urgency:               Routine Clinically Ind. Date:   Orderable Item:        COLONOSCOPY Procedure:             COLONOSCOPY Clinical Procedure:    COLONOSCOPY Reason For Request: (Do not use this to order a Colonoscopy....used for Endoworks equipment only) **see report   Inter-facility Information This is not an inter-facility consult request.  Status:                COMPLETE Last Action:           COMPLETE/UPDATE  Facility  Activity                Date/Time/Zone      Responsible Person  Entered By -------------------------------------------------------------------------------  CPRS RELEASED ORDER     02/09/11 07:22      CHALMERS,BONITA     KRUEGER,CORINNE L  INCOMPLETE RPT          02/09/11 10:26                          SHOLLER,WILMER      Note# 4702953  COMPLETE/UPDATE         02/09/11 10:00      CLINICAL,DEVICE P   SHURMAN,JILLIAN A                (entered) 02/09/11 11:00          Note# 4702953  Note: TIME ZONE is local if not indicated  --------------------------------------------------------------------------------   LOCAL TITLE: CP COLONOSCOPY                                      STANDARD TITLE: GASTROENTEROLOGY PROCEDURE NOTE                  DATE OF NOTE: FEB 09, 2011@10:25:46  ENTRY DATE: FEB 09, 2011@10:25:46             AUTHOR: CLINICAL,DEVICE PRO  EXP COSIGNER:                                 URGENCY:                            STATUS: COMPLETED                       PROCEDURE SUMMARY CODE: Machine Resulted               DATE/TIME PERFORMED: FEB 09, 2011@10:00    ** DOCUMENT IN VISTA IMAGING ** SEE FULL REPORT IN VISTA IMAGING  SIGNATURE NOT REQUIRED SEE SIGNATURE IN VISTA IMAGING  ** (OLYMPUS Colonoscopy)  AUTO-INSTRUMENT DIAGNOSIS **  Procedure: Col  Colonoscopy  Release Status: Released Off-Line Verified Date Verified: Feb 09, 2011@10:11  Indications: Surveillance of prior high grade adenoma (V12.72).   Consent: The benefits, risks, and alternatives to the procedure were  discussed and informed consent was obtained from the patient.   Preparation:  EKG, pulse, pulse oximetry and blood pressure were monitored  throughout the procedure. The patient received PEG in preparation for the  procedure. ASA Classification: Class 3 - Patient has severe systemic  disturbance that may or may not be related to the disorder requiring  surgery.   Medications: Versed 2 mg IV   Rectal Exam: Normal rectal exam.   Procedure:  The endoscope was passed with ease through the anus under  direct visualization and advanced to the cecum, confirmed by appendiceal  orifice and ileocecal valve. The scope was withdrawn and the mucosa was  carefully examined. The quality of the preparation was good. The views  were good. The patient's toleration of the procedure was good.Retroflexion was performed in the rectum.Findings:  There was evidence of diverticulosis in the sigmoid colon.On retroflexed view, internal hemorrhoids were found in the rectum.There  was evidence of prior colectomy in the colon.   Unplanned Events:  There were no unplanned events.Impressions: Diverticulosis (562.10) found in the sigmoid colon.Internal hemorrhoids in the rectum(455.0). Evidence of prior intervention in the colon.Personal history of polyps (V12.72)   Recommendations: Colonoscopy recommended in 5 years.Procedure Codes: 45378: Colonoscopy Version 1, electronically signed by Dr.John Beckman on 02/09/2011 at  10:18.    Administrative Closure: 02/09/2011                     by:                          CP CONSULT PROXY      ================================================================================ ==================================== END ===================================== </mcs_text>
        //            <mcs_flagSpecified>false</mcs_flagSpecified>
        //          </VIMTVIAEMRgcfpconsultsMultipleResponse>

        //Appointment Response
        //<? xml version = "1.0" ?>
        //< VIMTVIASchdMakeApptmakeAppointmentResponse xmlns:xsi= "http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd= "http://www.w3.org/2001/XMLSchema" >
        //  < MessageId > 6e159303 - d2dd - 4689 - 8a11-512da759a446</MessageId>
        //  <VIMTVIASchdMakeApptappointmentTOInfo>
        //    <mcs_timestamp>20170620.1100</mcs_timestamp>
        //    <mcs_purpose>4</mcs_purpose>
        //    <mcs_appointmentLength>15</mcs_appointmentLength>
        //    <mcs_appointmentType>9</mcs_appointmentType>
        //    <VIMTVIASchdMakeApptfacilityInfo />
        //    <VIMTVIASchdMakeApptclinicInfo>
        //      <mcs_id>325</mcs_id>
        //      <mcs_askForCheckInSpecified>false</mcs_askForCheckInSpecified>
        //    </VIMTVIASchdMakeApptclinicInfo>
        //  </VIMTVIASchdMakeApptappointmentTOInfo>
        //  <ExceptionOccured>false</ExceptionOccured>
        //</VIMTVIASchdMakeApptmakeAppointmentResponse>

    }
}
