﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Create;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor
{
    /// <summary>
    /// Virtual Meeting Room Processor for VIMT.
    /// </summary>
    public class VirtualMeetingRoomCreateProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VirtualMeetingRoomCreateRequestMessage.</param>
        /// <returns>VirtualMeetingRoomCreateResponseMessage.</returns>
        public IMessageBase Execute(VirtualMeetingRoomCreateRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, SetMeetingRoomNameStep>("SetMeetingRoomNameStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, GeneratePinsStep>("GeneratePinsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, SetMiscDataStep>("SetMiscDataStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, SerializeVmrStep>("SerializeVmrStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, ValidateXmlStep>("ValidateXmlStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, CreateMeetingRoomeRequestStep>("CreateMeetingRoomeRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, CreateUrlsStep>("CreateUrlsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, CompareUrlsStep>("CompareUrlsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomCreateStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VirtualMeetingRoomCreateStateObject(request))
            {
                new Pipeline<VirtualMeetingRoomCreateStateObject>()
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("SetMeetingRoomNameStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("GeneratePinsStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("SetMiscDataStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("SerializeVmrStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("ValidateXmlStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("CreateMeetingRoomeRequestStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("CreateUrlsStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("CompareUrlsStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomCreateStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VirtualMeetingRoomCreateResponseMessage;
            }
        }
    }
}