﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.MessageHandler
{
    /// <summary>
    /// Virtual Meeting Room handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VirtualMeetingRoomDeleteRequestMessage)]
    public class VirtualMeetingRoomDeleteHandler : RequestResponseHandler
    {
        private VirtualMeetingRoomDeleteRequestMessage _request;
        private string _serializedRequest;
        private System.Diagnostics.Stopwatch _timer;

        /// <summary>
        /// Handle the Virtual Meeting Request and send back a response.
        /// </summary>
        /// <param name="message">VirtualMeetingRoomDeleteRequestMessage.</param>
        /// <returns>VirtualMeetingRoomDeleteResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            _timer = new System.Diagnostics.Stopwatch();
            try
            {
                _timer.Start();
                _request = (VirtualMeetingRoomDeleteRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new VirtualMeetingRoomDeleteProcessor();
                var response = (VirtualMeetingRoomDeleteResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Virtual Meeting Room Delete: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                _timer.Stop();
                response.VimtProcessingMs = (int)_timer.ElapsedMilliseconds;

                return response;
            }
            catch (Exception ex)
            {
                return LogAndDeleteResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and Delete an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VirtualMeetingRoomDeleteResponseMessage.</returns>
        private VirtualMeetingRoomDeleteResponseMessage LogAndDeleteResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VirtualMeetingRoom Delete Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new VirtualMeetingRoomDeleteResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}