﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.MessageHandler
{
    /// <summary>
    /// Virtual Meeting Room handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VirtualMeetingRoomCreateRequestMessage)]
    public class VirtualMeetingRoomCreateHandler : RequestResponseHandler
    {
        private VirtualMeetingRoomCreateRequestMessage _request;
        private string _serializedRequest;
        private System.Diagnostics.Stopwatch _timer;

        /// <summary>
        /// Handle the Virtual Meeting Request and send back a response.
        /// </summary>
        /// <param name="message">VirtualMeetingRoomCreateRequestMessage.</param>
        /// <returns>VirtualMeetingRoomCreateResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            _timer = new System.Diagnostics.Stopwatch();
            try
            {
                _timer.Start();
                _request = (VirtualMeetingRoomCreateRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new VirtualMeetingRoomCreateProcessor();
                var response = (VirtualMeetingRoomCreateResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Virtual Meeting Room Create: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                _timer.Stop();
                response.VimtProcessingMs = (int)_timer.ElapsedMilliseconds;

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VirtualMeetingRoomCreateResponseMessage.</returns>
        private VirtualMeetingRoomCreateResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VirtualMeetingRoom Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new VirtualMeetingRoomCreateResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}