﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.Processor
{
    /// <summary>
    /// Video Visit Processor for VIMT.
    /// </summary>
    public class VideoVisitUpdateProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VideoVisitUpdateRequestMessage.</param>
        /// <returns>VideoVisitUpdateResponseMessage.</returns>
        public IMessageBase Execute(VideoVisitUpdateRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, GetProvidersStep>("GetProvidersStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, MapAppointmentStep>("MapAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, SerializeAppointmentStep>("SerializeAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, ValidateBusinessRulesStep>("ValidateBusinessRulesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, GetSamlTokenStep>("GetSamlTokenStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, PutToVideoVisitServiceStep>("PutToVideoVisitServiceStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitUpdateStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VideoVisitUpdateStateObject(request))
            {
                new Pipeline<VideoVisitUpdateStateObject>()
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("GetProvidersStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("MapAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("SerializeAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("ValidateBusinessRulesStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("GetSamlTokenStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("PutToVideoVisitServiceStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitUpdateStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VideoVisitUpdateResponseMessage;
            }
        }
    }
}