﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.Processor
{
    /// <summary>
    /// Video Visit Processor for VIMT.
    /// </summary>
    public class VideoVisitDeleteProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VideoVisitDeleteRequestMessage.</param>
        /// <returns>VideoVisitDeleteResponseMessage.</returns>
        public IMessageBase Execute(VideoVisitDeleteRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, MapAppointmentStep>("MapAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, SerializeAppointmentStep>("SerializeAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, GetSamlTokenStep>("GetSamlTokenStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, PutToVideoVisitServiceStep>("PutToVideoVisitServiceStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VideoVisitDeleteStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VideoVisitDeleteStateObject(request))
            {
                new Pipeline<VideoVisitDeleteStateObject>()
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("MapAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("SerializeAppointmentStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("GetSamlTokenStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("PutToVideoVisitServiceStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VideoVisitDeleteStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VideoVisitDeleteResponseMessage;
            }
        }
    }
}