﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.VideoVisit.Processor;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.MessageHandler
{
    /// <summary>
    /// Video Visit handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitCreateRequestMessage)]
    public class VideoVisitCreateHandler : RequestResponseHandler
    {
        private VideoVisitCreateRequestMessage _request;
        private string _serializedRequest;
        private System.Diagnostics.Stopwatch _timer;

        /// <summary>
        /// Handle the Video Visit Request and send back a response.
        /// </summary>
        /// <param name="message">VideoVisitCreateRequestMessage.</param>
        /// <returns>VideoVisitCreateResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            _timer = new System.Diagnostics.Stopwatch();
            try
            {
                _timer.Start();

                _request = (VideoVisitCreateRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new VideoVisitCreateProcessor();
                var response = (VideoVisitCreateResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Video Visit Create: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                _timer.Stop();
                response.VimtProcessingMs = (int)_timer.ElapsedMilliseconds;
                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VideoVisitCreateResponseMessage.</returns>
        private VideoVisitCreateResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: Video Visit Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new VideoVisitCreateResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}