﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.PipelineSteps.GetPersonIdentifiers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.Processor
{
    /// <summary>
    /// Get Person Identifiers Processor for VIMT.
    /// </summary>
    public class GetPersonIdentifiersProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">GetPersonIdentifiersRequestMessage.</param>
        /// <returns>GetPersonIdentifiersResponseMessage.</returns>
        public IMessageBase Execute(GetPersonIdentifiersRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, IsSearchNeededStep>("IsSearchNeededStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, MapGetPersonIdentifiersToGetIdsStep>("MapGetPersonIdentifiersToGetIdsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, SendSelectedPersonRequestToEcStep>("SendSelectedPersonRequestToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, SaveContactAndIdsIntoCrmStep>("SaveContactAndIdsIntoCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, MapCorrespondingIdsResponseToGetPersonIdentifiersResponseStep>("MapCorrespondingIdsResponseToGetPersonIdentifiersResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetPersonIdentifiersStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new GetPersonIdentifiersStateObject(request))
            {
                new Pipeline<GetPersonIdentifiersStateObject>()
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("IsSearchNeededStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("MapGetPersonIdentifiersToGetIdsStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("SendSelectedPersonRequestToEcStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("SaveContactAndIdsIntoCrmStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("MapCorrespondingIdsResponseToGetPersonIdentifiersResponseStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<GetPersonIdentifiersStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.GetPersonIdentifiersResponseMessage;
            }
        }
    }
}