﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.Processor;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.MessageHandler
{
    /// <summary>
    /// Proxy Add handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.ProxyAddRequestMessage)]
    public class ProxyAddHandler : RequestResponseHandler
    {
        private ProxyAddRequestMessage _request;
        private string _serializedRequest;
        private System.Diagnostics.Stopwatch _timer;

        /// <summary>
        /// Handle the Person Search Request and send back a response.
        /// </summary>
        /// <param name="message">PersonSearchRequestMessage.</param>
        /// <returns>ProxyAddResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _timer = new System.Diagnostics.Stopwatch();
                _timer.Start();

                _request = (ProxyAddRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new ProxyAddProcessor();
                var response = (ProxyAddResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: MVI Proxy Add: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                _timer.Stop();
                response.VimtProcessingMs = (int)_timer.ElapsedMilliseconds;

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>ProxyAddResponseMessage.</returns>
        private ProxyAddResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: MVI Proxy Add Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new ProxyAddResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}