﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.Processor;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.MessageHandler
{
    /// <summary>
    /// Get Person Identifiers handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.GetPersonIdentifiersRequestMessage)]
    public class GetPersonIdentifiersHandler : RequestResponseHandler
    {
        private GetPersonIdentifiersRequestMessage _request;
        private string _serializedRequest;
        private System.Diagnostics.Stopwatch _timer;

        /// <summary>
        /// Handle the Get Person Identifiers Request and send back a response.
        /// </summary>
        /// <param name="message">GetPersonIdentifiersRequestMessage.</param>
        /// <returns>GetPersonIdentifiersResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            _timer = new System.Diagnostics.Stopwatch();
            try
            {
                _timer.Start();
                _request = (GetPersonIdentifiersRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new GetPersonIdentifiersProcessor();
                var response = (GetPersonIdentifiersResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: MVI Get Person Identifiers: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);
                _timer.Stop();
                response.VimtProcessingMs = (int)_timer.ElapsedMilliseconds;
                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>GetPersonIdentifiersResponseMessage.</returns>
        private GetPersonIdentifiersResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: MVI Get Person Identifiers Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            _timer.Stop();
            return new GetPersonIdentifiersResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest,
                VimtProcessingMs = (int)_timer.ElapsedMilliseconds
            };
        }
    }
}