﻿using System;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Mvi.PersonSearch.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.Mappers
{
    /// <summary>
    /// Maps Patient/Provider data to a Proxy Add to Vista request.
    /// </summary>
    public class ProxyAddMapper
    {
        private readonly ProxyAddStateObject _state;
        private readonly bool _isPatient;

        /// <summary>
        /// Default constructor.
        /// </summary>
        /// <param name="state">State.</param>
        /// <param name="isPatient">Whether Patient or Provider.</param>
        public ProxyAddMapper(ProxyAddStateObject state, bool isPatient)
        {
            _state = state;
            _isPatient = isPatient;
        }

        /// <summary>
        /// Map Patient/Provider data to Proxy Add to Vista request.
        /// </summary>
        /// <returns>ProxyAddToVistaRequest</returns>
        public ProxyAddToVistaRequest Map()
        {
            if (_state.Veteran.BirthDate == null) throw new Exception("Veteran's birth date cannot be null");

            var proxyAddToVistaRequest = new ProxyAddToVistaRequest
            {
                OrganizationName = _state.OrganizationName,
                Requestor = new CrmUser { UserId = _state.UserId, LastName = _state.UserLastName, FirstName = _state.UserFirstName },
                ProcessingCode = _state.ProcessingCode,
                MviIdentifier = new Identifier
                {
                    Id = _state.VeteranIcn.mcs_identifier,
                    Type = IdentifierType.NationalIdentifier,
                    AssigningFacility = "200M",
                    AssigningAuthority = "USVHA"
                },
                SocialSecurityNumber = new Identifier
                {
                    Id = _state.VeteranSs.mcs_identifier,
                    Type = IdentifierType.SocialSecurityNumber,
                    AssigningFacility = _state.VeteranSs.mcs_assigningfacility,
                    AssigningAuthority = _state.VeteranSs.mcs_assigningauthority
                },
                VistaIdentifier = new Identifier
                {
                    Id = _isPatient ? _state.PatientSideIdentifierToAdd.mcs_identifier : _state.ProviderSideIdentifierToAdd.mcs_identifier,
                    Type = IdentifierType.PatientIdentifier,
                    AssigningFacility = _isPatient ? _state.PatientSideIdentifierToAdd.mcs_assigningfacility : _state.ProviderSideIdentifierToAdd.mcs_assigningfacility,
                    AssigningAuthority = _isPatient ? _state.PatientSideIdentifierToAdd.mcs_assigningauthority : _state.ProviderSideIdentifierToAdd.mcs_assigningauthority
                },
                FamilyName = _state.Veteran.LastName,
                GivenName = _state.Veteran.FirstName,
                GenderCode = _state.Veteran.GenderCode != null ? _state.Veteran.GenderCode.Value == 1 ? GenderCode.M : GenderCode.F : GenderCode.NotSpecified,
                BirthDate = _state.Veteran.BirthDate.Value.ToString("yyyyMMdd"),
                ReturnMviMessagesInResponse = _state.ReturnMviMessagesInResponse,
                PatientVeteran = _state.PatientVeteran,
                PatientServiceConnected = _state.PatientServiceConnected,
                PatientType = _state.PatientType
            };

            Logger.Instance.Debug(string.Format("Proxy Add to Vista Request - {0}", Shared.PipelineUtilities.SerializeInstance(proxyAddToVistaRequest)));

            return proxyAddToVistaRequest;
        }
    }
}