﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [DataContract]
    public class VistaAppointment
    {
        [DataMember]
        public Guid AppointmentId { get; set; }

        [DataMember]
        public Guid ServiceAppointmentId { get; set; }

        [DataMember]
        public PersonName PatientName { get; set; }

        [DataMember]
        public string PatientIcn { get; set; }

        [DataMember]
        public string FacilityName { get; set; }

        [DataMember]
        public string FacilityStationCode { get; set; }

        [DataMember]
        public string ClinicName { get; set; }

        [DataMember]
        public string ClinicIen { get; set; }

        [DataMember]
        public string LocalStartTime { get; set; }

        [DataMember]
        public string Duration { get; set; }

        [DataMember]
        public VistaAppointmentStatus Status { get; set; }

        [DataMember]
        public string ErrorMessage { get; set; }

        [DataMember]
        public VistaCancelCode CancelCode { get; set; }

        [DataMember]
        public VistaCancelReason CancelReason { get; set; }

        [DataMember]
        public string CancelRemarks { get; set; }
    }

    public enum VistaAppointmentStatus
    {
        BOOKED,
        FAILED_TO_BOOK,
        RECEIVED,
        FAILED_TO_RECEIVE,
        CANCELLED,
        FAILED_TO_CANCEL
    }

    public enum VistaCancelCode
    {
        NO_SHOW,
        CANCELLED_BY_CLINIC,
        CANCELLED_BY_CLINIC_AND_AUTO_RE_BOOK,
        NO_SHOW_AND_AUTO_RE_BOOK,
        INPATIENT_APPOINTMENT,
        CANCELLED_BY_PATIENT,
        CANCELLED_BY_PATIENT_AND_AUTO_RE_BOOK,
        NO_ACTION_TAKEN
    }

    public enum VistaCancelReason
    {
        UNKOWN = 0,
        WEATHER = 1,
        INPATIENT_STATUS = 2,
        PATIENT_DEATH = 3,
        TRAVEL_DIFFICULTY = 4,
        UNABLE_TO_KEEP_APPOINTMENT = 5,
        DEATH_IN_FAMILY = 6,
        CLINIC_STAFFING = 7,
        SCHEDULING_CONFLICT_ERROR = 8,
        PATIENT_NOT_ELIGIBLE = 9,
        APPOINTMENT_NO_LONGER_REQUIRED = 10,
        OTHER = 11,
        TRANSFER_OPT_CARE_TO_OTHER_VA = 12,
        CLINIC_CANCELLED = 13,
    }

    [DataContract]
    public class PersonName
    {
        [DataMember]
        public string FirstName { get; set; }

        [DataMember]
        public string LastName { get; set; }

        [DataMember]
        public string MiddleInitial { get; set; }
    }

}
