﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.LoginToSiteResponseMessage)]
    [DataContract]
    public class LoginToSiteRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log requests.
        /// </summary>
        [DataMember]
        public bool LogRequest { get; set; }

        /// <summary>
        /// The Vista Number for the station being logged into
        /// </summary>
        [DataMember]
        public string stationNumber { get; set; }

        /// <summary>
        /// Determines whether a Login attempt should be faked or not
        /// </summary>
        [DataMember]
        public string FakeResponseType { get; set; }
    }
}
