using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
	[Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.GetConsultsForPatientRequest)]
	[DataContract]
	public class GetConsultsForPatientRequest : TmpVimtRequestMessage
    {
		[DataMember]
		public Guid RelatedParentId { get; set; }
		[DataMember]
		public string RelatedParentEntityName { get; set; }
		[DataMember]
		public string RelatedParentFieldName { get; set; }
		[DataMember]
		public bool LogTiming { get; set; }
		[DataMember]
		public bool LogSoap { get; set; }
		[DataMember]
		public bool Debug { get; set; }
        [DataMember]
		public GetConsultsForPatientReqQueryBean GetConsultsForPatientReqQueryBeanInfo { get; set; }

        //[DataMember]
        //public List<Guid> ProviderIds { get; set; }

        [DataMember]
        public List<Guid> PatientIds { get; set; }

        [DataMember]
        public string PatLoginSiteCode { get; set; }

        [DataMember]
        public string ProLoginSiteCode { get; set; }

        [DataMember]
        public bool IsHomeMobile { get; set; }

        [DataMember]
        public bool IsStoreForward { get; set; }

        [DataMember]
        public string SAMLToken { get; set; }

        [DataMember]
        public string PatUserDuz { get; set; }

        [DataMember]
        public string ProUserDuz { get; set; }
    }

    [DataContract]
	public class GetConsultsForPatientReqQueryBean
	{
		[DataMember]
		public string RecordSiteCode { get; set; }
		[DataMember]
		public string RequestingApp { get; set; }
		[DataMember]
		public string Active { get; set; }
		[DataMember]
		public string EndDate { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string MaxRecords { get; set; }
		[DataMember]
		public string Status { get; set; } //can filter by status - this field performs that filter (3, 6)
		[DataMember]
		public string SupplementalParameters { get; set; }
		[DataMember]
		public string ItemId { get; set; }
		[DataMember]
		public string Target { get; set; }
		[DataMember]
		public string Criteria { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string Direction { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public bool MultiSiteQuery { get; set; }
		[DataMember]
		public string ConsumingAppToken { get; set; }
		[DataMember]
		public string ConsumingAppPassword { get; set; }
		[DataMember]
		public GetConsultsForPatientReqProvider GetConsultsForPatientReqProviderInfo { get; set; }
		[DataMember]
		public GetConsultsForPatientReqPatient GetConsultsForPatientReqPatientInfo { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientReqProvider
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string UserId { get; set; }
		[DataMember]
		public string LoginSiteCode { get; set; }
		[DataMember]
		public string ContextMenu { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
	}

	[DataContract]
	public class GetConsultsForPatientReqPatient
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string LocalPid { get; set; }
		[DataMember]
		public string LocalSiteId { get; set; }
		[DataMember]
		public string MpiPid { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string InPatient { get; set; }
		[DataMember]
		public string Age { get; set; }
		[DataMember]
		public string Gender { get; set; }
		[DataMember]
		public string ScPercentage { get; set; }
	}
}