using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.GetClinicsResponseMessage)]
	[DataContract]
	public class GetClinicsResponseMessage : TmpVimtResponseMessage
	{
		[DataMember]
		public GetClinicsRespTaggedHospitalLocationArray GetClinicsRespTaggedHospitalLocationArrayInfo { get; set; }
    }

	[DataContract]
	public class GetClinicsRespTaggedHospitalLocationArray
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetClinicsRespLocationsMultipleResponse[] GetClinicsRespLocationsInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault16 GetClinicsRespFault16Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespLocationsMultipleResponse
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string ClinicDisplayStartTime { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public GetClinicsRespDepartment GetClinicsRespDepartmentInfo { get; set; }
		[DataMember]
		public GetClinicsRespService GetClinicsRespServiceInfo { get; set; }
		[DataMember]
		public GetClinicsRespSpecialty GetClinicsRespSpecialtyInfo { get; set; }
		[DataMember]
		public GetClinicsRespStopCode GetClinicsRespStopCodeInfo { get; set; }
		[DataMember]
		public GetClinicsRespCreditStopCode GetClinicsRespCreditStopCodeInfo { get; set; }
		[DataMember]
		public GetClinicsRespFacility GetClinicsRespFacilityInfo { get; set; }
		[DataMember]
		public GetClinicsRespAvailability GetClinicsRespAvailabilityInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault15 GetClinicsRespFault15Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespDepartment
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResultsMultipleResponse[] GetClinicsRespTaggedResultsInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault GetClinicsRespFaultInfo { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class GetClinicsRespService
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults1MultipleResponse[] GetClinicsRespTaggedResults1Info { get; set; }
		[DataMember]
		public GetClinicsRespFault1 GetClinicsRespFault1Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults1MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespSpecialty
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults2MultipleResponse[] GetClinicsRespTaggedResults2Info { get; set; }
		[DataMember]
		public GetClinicsRespFault2 GetClinicsRespFault2Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults2MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults3MultipleResponse[] GetClinicsRespTaggedResults3Info { get; set; }
		[DataMember]
		public GetClinicsRespFault3 GetClinicsRespFault3Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults3MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault3
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespCreditStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults4MultipleResponse[] GetClinicsRespTaggedResults4Info { get; set; }
		[DataMember]
		public GetClinicsRespFault4 GetClinicsRespFault4Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults4MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault4
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFacility
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public GetClinicsRespDataSources GetClinicsRespDataSourcesInfo { get; set; }
		[DataMember]
		public GetClinicsRespChildSites GetClinicsRespChildSitesInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault12 GetClinicsRespFault12Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespDataSources
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetClinicsRespItemsMultipleResponse[] GetClinicsRespItemsInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault7 GetClinicsRespFault7Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespItemsMultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public GetClinicsRespSiteId GetClinicsRespSiteIdInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault6 GetClinicsRespFault6Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespSiteId
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults5MultipleResponse[] GetClinicsRespTaggedResults5Info { get; set; }
		[DataMember]
		public GetClinicsRespFault5 GetClinicsRespFault5Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults5MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault5
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault6
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault7
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespChildSites
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetClinicsRespSitesMultipleResponse[] GetClinicsRespSitesInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault11 GetClinicsRespFault11Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespSitesMultipleResponse
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public GetClinicsRespDataSources1 GetClinicsRespDataSources1Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespDataSources1
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetClinicsRespItems1MultipleResponse[] GetClinicsRespItems1Info { get; set; }
		[DataMember]
		public GetClinicsRespFault10 GetClinicsRespFault10Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespItems1MultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public GetClinicsRespSiteId1 GetClinicsRespSiteId1Info { get; set; }
		[DataMember]
		public GetClinicsRespFault9 GetClinicsRespFault9Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespSiteId1
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public GetClinicsRespTaggedResults6MultipleResponse[] GetClinicsRespTaggedResults6Info { get; set; }
		[DataMember]
		public GetClinicsRespFault8 GetClinicsRespFault8Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespTaggedResults6MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault8
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault9
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault10
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault11
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault12
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespAvailability
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public GetClinicsRespSlotsMultipleResponse[] GetClinicsRespSlotsInfo { get; set; }
		[DataMember]
		public GetClinicsRespFault14 GetClinicsRespFault14Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespSlotsMultipleResponse
	{
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public GetClinicsRespFault13 GetClinicsRespFault13Info { get; set; }
	}

	[DataContract]
	public class GetClinicsRespFault13
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault14
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault15
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class GetClinicsRespFault16
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}