using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.EmrLoginViaResponse)]
	[DataContract]
	public class EmrLoginViaResponse : TmpVimtResponseMessage
	{
		[DataMember]
		public EmrLoginViaRespUserTo EmrLoginViaRespUserToInfo { get; set; }
        [DataMember]
        public string ViaUserId { get; set; }
    }

	[DataContract]
	public class EmrLoginViaRespUserTo
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string Duz { get; set; }
		[DataMember]
		public string SiteId { get; set; }
		[DataMember]
		public string Office { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string Pager { get; set; }
		[DataMember]
		public string Service { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string OrderRole { get; set; }
		[DataMember]
		public string UserClass { get; set; }
		[DataMember]
		public string Greeting { get; set; }
		[DataMember]
		public string SiteMessage { get; set; }
		[DataMember]
		public string EmailAddress { get; set; }
		[DataMember]
		public string Username { get; set; }
		[DataMember]
		public string VistaDuz { get; set; }
		[DataMember]
		public EmrLoginViaRespIds EmrLoginViaRespIdsInfo { get; set; }
		[DataMember]
		public EmrLoginViaRespDivisionsMultipleResponse[] EmrLoginViaRespDivisionsInfo { get; set; }
		[DataMember]
		public EmrLoginViaRespFault2 EmrLoginViaRespFault2Info { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespIds
	{
		[DataMember]
		public bool TextOnly { get; set; }
		[DataMember]
		public bool TextOnlySpecified { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public EmrLoginViaRespResultsMultipleResponse[] EmrLoginViaRespResultsInfo { get; set; }
		[DataMember]
		public EmrLoginViaRespFault1 EmrLoginViaRespFault1Info { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public EmrLoginViaRespTaggedResultsMultipleResponse[] EmrLoginViaRespTaggedResultsInfo { get; set; }
		[DataMember]
		public EmrLoginViaRespFault EmrLoginViaRespFaultInfo { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class EmrLoginViaRespDivisionsMultipleResponse
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string SiteId { get; set; }
	}

	[DataContract]
	public class EmrLoginViaRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}