using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
	[Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.EmrLoginViaRequest)]
	[DataContract]
	public class EmrLoginViaRequest : TmpVimtRequestMessage
	{
		[DataMember]
		public Guid RelatedParentId { get; set; }
		[DataMember]
		public string RelatedParentEntityName { get; set; }
		[DataMember]
		public string RelatedParentFieldName { get; set; }
		[DataMember]
		public bool LogTiming { get; set; }
		[DataMember]
		public bool LogSoap { get; set; }
		[DataMember]
		public bool Debug { get; set; }
		[DataMember]
		public string Sitecode { get; set; } //use this for the station
		[DataMember]
		public string Accesscode { get; set; } //if using tokens - ignore this
		[DataMember]
		public string Verifycode { get; set; } //if using tokens - ignore this
        [DataMember]
        public string StationNumber { get; set; }
        [DataMember]
        public string FakeResponseType { get; set; }
        [DataMember]
		public EmrLoginViaReqQueryBean EmrLoginViaReqQueryBeanInfo { get; set; }
	}

	[DataContract]
	public class EmrLoginViaReqQueryBean
	{
		[DataMember]
		public string RecordSiteCode { get; set; }
		[DataMember]
		public string RequestingApp { get; set; } //required
		[DataMember]
		public string Active { get; set; }
		[DataMember]
		public string EndDate { get; set; }
		[DataMember]
		public string StartDate { get; set; }
		[DataMember]
		public string MaxRecords { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string SupplementalParameters { get; set; }
		[DataMember]
		public string ItemId { get; set; }
		[DataMember]
		public string Target { get; set; }
		[DataMember]
		public string Criteria { get; set; } // this is the string representation of the full xml of the token - use either this or the access/verify code
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string Direction { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public bool MultiSiteQuery { get; set; }
		[DataMember]
		public string ConsumingAppToken { get; set; } //required
		[DataMember]
		public string ConsumingAppPassword { get; set; } //required
		[DataMember]
		public EmrLoginViaReqProvider EmrLoginViaReqProviderInfo { get; set; } //ignore- optional
		[DataMember]
		public EmrLoginViaReqPatient EmrLoginViaReqPatientInfo { get; set; } //ignore - optional
	}

	[DataContract]
	public class EmrLoginViaReqProvider
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string UserId { get; set; }
		[DataMember]
		public string LoginSiteCode { get; set; }
		[DataMember]
		public string ContextMenu { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
	}

	[DataContract]
	public class EmrLoginViaReqPatient
	{
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string LocalPid { get; set; }
		[DataMember]
		public string LocalSiteId { get; set; }
		[DataMember]
		public string MpiPid { get; set; }
		[DataMember]
		public string VistaLocations { get; set; }
		[DataMember]
		public string Ss { get; set; }
		[DataMember]
		public string InPatient { get; set; }
		[DataMember]
		public string Age { get; set; }
		[DataMember]
		public string Gender { get; set; }
		[DataMember]
		public string ScPercentage { get; set; }
	}
}