﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom
{
    /// <summary>
    /// VIMT message for VirtualMeetingRoomCreateRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VirtualMeetingRoomCreateRequestMessage)]
    [DataContract]
    public class VirtualMeetingRoomCreateRequestMessage : TmpVimtRequestMessage
    {
        /// <summary>
        /// Gets or sets the Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the Patient Id.
        /// </summary>
        [DataMember]
        public Guid PatientId { get; set; }

        /// <summary>
        /// Gets or sets the Provider Id.
        /// </summary>
        [DataMember]
        public Guid ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Misc Flag.
        /// </summary>
        [DataMember]
        public string MiscData { get; set; }
    }
}