﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    /// <summary>
    /// VIMT message for VideoVisitDeleteRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitDeleteRequestMessage)]
    [DataContract]
    public class VideoVisitDeleteRequestMessage : TmpVimtRequestMessage
    {
        /// <summary>
        /// Gets or sets the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// List of patient IDs who are being canceled
        /// </summary>
        [DataMember]
        public List<Guid> CanceledPatients { get; set; }

        /// <summary>
        /// indiciates if an individual patient is being canceled, or if it is the whole appointment
        /// </summary>
        [DataMember]
        public bool WholeAppointmentCanceled { get; set; }
    }
}