﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;
using System.Collections.Generic;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    /// <summary>
    /// VIMT message for VideoVisitCreateRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitCreateRequestMessage)]
    [DataContract]
    public class VideoVisitCreateRequestMessage : TmpVimtRequestMessage
    {
        /// <summary>
        /// Gets or sets the Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// List of patients being booked
        /// </summary>
        [DataMember]
        public List<Guid> AddedPatients { get; set; }
    }
}