﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace VA.TMP.Integration.VIMT.Messages.VideoVisit
{
    [DataContract]
    public class WriteResults
    {
        [DataMember]
        public WriteResult[] WriteResult { get; set; }
    }

    [DataContract]
    public class WriteResult
    {
        [DataMember]
        public string PersonId { get; set; }

        [DataMember]
        public PersonName Name { get; set; }

        [DataMember]
        public string FacilityCode { get; set; }

        [DataMember]
        public string FacilityName { get; set; }

        [DataMember]
        public string ClinicIen { get; set; }

        [DataMember]
        public string ClinicName { get; set; }

        [DataMember]
        public string DateTime { get; set; }

        [DataMember]
        public VistaStatus VistaStatus { get; set; }

        [DataMember]
        public string Reason { get; set; }
    }

    public enum VistaStatus
    {
        BOOKED,
        FAILED_TO_BOOK,
        RECEIVED,
        FAILED_TO_RECEIVE,
        CANCELLED,
        FAILED_TO_CANCEL
    }

    [DataContract]
    public class PersonName
    {
        [DataMember]
        public string FirstName { get; set; }

        [DataMember]
        public string LastName { get; set; }

        [DataMember]
        public string MiddleInitial { get; set; }
    }


}
