﻿using System;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Mvi
{
    /// <summary>
    /// VIMT message for RetrieveOrSearchPersonResponse.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.GetPersonIdentifiersRequestMessage)]
    [DataContract]
    public class RetrieveOrSearchPersonResponse
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string MessageId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public Acknowledgement Acknowledgement { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Message { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public PatientPerson[] Person { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public QueryAcknowledgement QueryAcknowledgement { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string RawMviExceptionMessage { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class Acknowledgement
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public AcknowledgementDetail[] AcknowledgementDetails { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string TargetMessage { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string TypeCode { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class AcknowledgementDetail
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public AcknowledgementDetailCode Code { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Text { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class AcknowledgementDetailCode
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Code { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string CodeSystemName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string DisplayName { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public enum MessageProcessType
    {
        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Local = 0,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Remote = 1,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        RemoteQueued = 2,
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class PatientPerson
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public PatientAddress Address { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string BirthDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string BranchOfService { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public UnattendedSearchRequest[] CorrespondingIdList { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string DeceasedDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string EdiPi { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string GenderCode { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Identifier { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string IdentifierType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string IdentifyTheft { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string IsDeceased { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public Name[] NameList { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string ParticipantId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string PhoneNumber { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string RecordSource { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Ss { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string StatusCode { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Url { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string FullName
        {
            get
            {
                const string nameFormat = "{0} {1}";
                if (NameList != null && NameList.Any()) return string.Format(nameFormat, NameList[0].GivenName, NameList[0].FamilyName);

                return string.Empty;
            }
        }

        /// <summary>
        /// The full address of the person associated with the identifier.
        /// </summary>
        [DataMember]
        public string FullAddress
        {
            get
            {
                if (Address == null) return string.Empty;
                return Address.ToString();
            }
        }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class PatientAddress
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string City { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string Country { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string PostalCode { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string State { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string StreetAddressLine { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public AddressUse Use { get; set; }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return string.Format("{0}\n{1}, {2} {3} {4}", StreetAddressLine, City, State, PostalCode, Country).TrimEnd(new[] { '\n', ',' }).Trim();
        }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public enum AddressUse
    {
        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Unspecified = 0,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Bad = 1,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Confidential = 2,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Home = 3,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        PrimaryHome = 4,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        OtherHome = 5,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Temporary = 6,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Workplace = 7,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Other = 8,
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class UnattendedSearchRequest
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string AssigningAuthority { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string AssigningFacility { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string AuthorityOid { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string IdentifierType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string PatientIdentifier { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string RawValueFromMvi { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public bool UseRawMviValue { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string UserFirstName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string UserLastName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return string.Format("{0}^{1}^{2}^{3}", PatientIdentifier, IdentifierType, AssigningFacility, AssigningAuthority);
        }

    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class Name
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string GivenName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string MiddleName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string NamePrefix { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string NameSuffix { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string NameType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public NameUse Use { get; set; }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            var nameString = string.Empty;

            if (!string.IsNullOrEmpty(FamilyName))
            {
                nameString += FamilyName;

                if (!string.IsNullOrEmpty(NameSuffix)) nameString += " " + NameSuffix;

                nameString += ",";
            }

            if (!string.IsNullOrEmpty(GivenName)) nameString += " " + GivenName;

            if (!string.IsNullOrEmpty(MiddleName)) nameString += " " + MiddleName;

            return nameString.Trim().TrimEnd(',');
        }
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public enum NameUse
    {
        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Unspecified = 0,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Assigned = 1,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Certificate = 2,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        OfficialRegistry = 3,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Indigenous = 4,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Legal = 5,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Pseudoymn = 6,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Religous = 7,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Maiden = 8,

        /// <summary>
        /// 
        /// </summary>
        [EnumMember]
        Alias = 9,
    }

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class QueryAcknowledgement
    {
        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string QueryResponseCode { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [DataMember]
        public string ResultCurrentQuantity { get; set; }
    }
}