﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Mvi
{
    /// <summary>
    /// VIMT message for ProxyAddResponseMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.GetPersonIdentifiersResponseMessage)]
    [DataContract]
    public class GetPersonIdentifiersResponseMessage : TmpVimtResponseMessage
    {
        /// <summary>
        /// The URL for the contact record associated with these identifiers.
        /// </summary>
        [DataMember]
        public string Url { get; set; }

        /// <summary>
        /// The type of message processing.
        /// </summary>
        [DataMember]
        public MessageProcessType FetchMessageProcessType { get; set; }

        /// <summary>
        /// The social security number of the veteran.
        /// </summary>
        [DataMember]
        public string Ss { get; set; }

        /// <summary>
        /// The EDIPI number of the veteran.
        /// </summary>
        [DataMember]
        public string Edipi { get; set; }

        /// <summary>
        /// The participant identifier of the veteran.
        /// </summary>
        [DataMember]
        public string ParticipantId { get; set; }

        /// <summary>
        /// The first name of the veteran.
        /// </summary>
        [DataMember]
        public string FirstName { get; set; }

        /// <summary>
        /// The middle name of the veteran.
        /// </summary>
        [DataMember]
        public string MiddleName { get; set; }

        /// <summary>
        /// The last name of the veteran.
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// suffix of the veteran
        /// </summary>
        [DataMember]
        public string Suffix { get; set; }

        /// <summary>
        /// The CRM user id of the requestor.
        /// </summary>
        [DataMember]
        public Guid UserId { get; set; }

        /// <summary>
        /// The full address for the veteran.
        /// </summary>
        [DataMember]
        public string FullAddress { get; set; }

        /// <summary>
        /// The data of birth of the veteran.
        /// </summary>
        [DataMember]
        public string DateofBirth { get; set; }

        /// <summary>
        /// The full name of the veteran.
        /// </summary>
        [DataMember]
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the Contact Id.
        /// </summary>
        [DataMember]
        public Guid ContactId { get; set; }

        /// <summary>
        /// An array of identifiers associated with the veteran.
        /// </summary>
        [DataMember]
        public List<UnattendedSearchRequest> CorrespondingIdList { get; set; }
    }
}