﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// VIMT message for TmpHealthShareUpdateClinicRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareUpdateClinicRequestMessage)]
    [DataContract]
    public class TmpHealthShareUpdateClinicRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the Institution.
        /// </summary>
        [DataMember]
        public int Institution { get; set; }

        /// <summary>
        /// Gets or sets the Visn.
        /// </summary>
        [DataMember]
        public int Visn { get; set; }

        /// <summary>
        /// Gets or sets the StationNumber.
        /// </summary>
        [DataMember]
        public string StationNumber { get; set; }

        /// <summary>
        /// Gets or sets the PrimaryStopCode.
        /// </summary>
        [DataMember]
        public int PrimaryStopCode { get; set; }

        /// <summary>
        /// Gets or sets the SecondaryStopCode.
        /// </summary>
        [DataMember]
        public int SecondaryStopCode { get; set; }

        /// <summary>
        /// Gets or sets the ClinicIen.
        /// </summary>
        [DataMember]
        public int ClinicIen { get; set; }

        /// <summary>
        /// Gets or sets the ClinicName.
        /// </summary>
        [DataMember]
        public string ClinicName { get; set; }

        /// <summary>
        /// Gets or sets the TreatingSpecialty.
        /// </summary>
        [DataMember]
        public string TreatingSpecialty { get; set; }

        /// <summary>
        /// Gets or sets the Service.
        /// </summary>
        [DataMember]
        public string Service { get; set; }

        /// <summary>
        /// Gets or sets the DefaultProviderId.
        /// </summary>
        [DataMember]
        public string DefaultProviderId { get; set; }

        /// <summary>
        /// Gets or sets the DefaultProviderName.
        /// </summary>
        [DataMember]
        public string DefaultProviderName { get; set; }

        /// <summary>
        /// Gets or sets the DefaultProviderEmail.
        /// </summary>
        [DataMember]
        public string DefaultProviderEmail { get; set; }

        /// <summary>
        /// Gets or sets the OverBookAllowed.
        /// </summary>
        [DataMember]
        public int OverBookAllowed { get; set; }

        /// <summary>
        /// Gets or sets the ClinicStatus.
        /// </summary>
        [DataMember]
        public string ClinicStatus { get; set; }

        /// <summary>
        /// Gets or sets the ActionDateTime.
        /// </summary>
        [DataMember]
        public string ActionDateTime { get; set; }

        /// <summary>
        /// Gets or sets the PrivilegedUsers.
        /// </summary>
        [DataMember]
        public List<PrivilegedUser> PrivilegedUsers { get; set; }
    }

    /// <summary>
    /// PrivilegedUser class.
    /// </summary>
    [DataContract]
    public class PrivilegedUser
    {
        /// <summary>
        /// Gets or sets the User.
        /// </summary>
        [DataMember]
        public string User { get; set; }

        /// <summary>
        /// Gets or sets the UserDuz.
        /// </summary>
        [DataMember]
        public string UserDuz { get; set; }

        /// <summary>
        /// Gets or sets the UserEmail.
        /// </summary>
        [DataMember]
        public string UserEmail { get; set; }
    }
}