﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// Tmp HealthShare Make Cancel Outbound Response.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareMakeCancelOutboundResponseMessage)]
    [DataContract]
    public class TmpHealthShareMakeCancelOutboundResponseMessage : TmpVimtResponseMessage
    {
        /// <summary>
        /// Default Constructor.
        /// </summary>
        public TmpHealthShareMakeCancelOutboundResponseMessage()
        {
            PatientIntegrationResultInformation = new List<PatientIntegrationResultInformation>();
        }

        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        [DataMember]
        public List<PatientIntegrationResultInformation> PatientIntegrationResultInformation { get; set; }
    }

    /// <summary>
    /// Contains information needed to build an Integration Result.
    /// </summary>
    [DataContract]
    public class PatientIntegrationResultInformation
    {
        /// <summary>
        /// Gets or sets the Control Id.
        /// </summary>
        [DataMember]
        public string ControlId { get; set; }

        /// <summary>
        /// Gets or sets the PatientId.
        /// </summary>
        [DataMember]
        public Guid PatientId { get; set; }

        /// <summary>
        /// Gets or sets the VimtRequest.
        /// </summary>
        [DataMember]
        public string VimtRequest { get; set; }

        /// <summary>
        /// Gets or sets the VimtResponse.
        /// </summary>
        [DataMember]
        public string VimtResponse { get; set; }

        /// <summary>
        /// Gets or sets EcProcessing time.
        /// </summary>
        [DataMember]
        public int EcProcessingMs { get; set; }

        /// <summary>
        /// Gets or sets Exception Message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets whether an Exception occurred.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }
    }
}