﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// VIMT message for TmpHealthShareMakeCancelOutboundRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareMakeCancelOutboundRequestMessage)]
    [DataContract]
    public class TmpHealthShareMakeCancelOutboundRequestMessage : TmpVimtRequestMessage
    {
        /// <summary>
        /// Default Constructor.
        /// </summary>
        public TmpHealthShareMakeCancelOutboundRequestMessage()
        {
            Patients = new List<Guid>();
        }

        /// <summary>
        /// Gets or Sets Patient.
        /// </summary>
        [DataMember]
        public List<Guid> Patients { get; set; }
        
        /// <summary>
        /// Gets or Sets Service Appointment Id.
        /// </summary>
        [DataMember]
        public Guid ServiceAppointmentId { get; set; }

        /// <summary>
        /// Gets or Sets Appointment Id.
        /// </summary>
        [DataMember]
        public Guid? AppointmentId { get; set; }

        /// <summary>
        /// Gets or Sets VisitStatus.
        /// </summary>
        [DataMember]
        public string VisitStatus { get; set; }

        /// <summary>
        /// Gets or Sets Vista Integration Result in the case of Group Cancel.
        /// </summary>
        [DataMember]
        public Guid? VistaIntegrationResultId { get; set; }
    }
}