﻿using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// VIMT message for TmpHealthShareMakeAndCancelAppointmentRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareMakeAndCancelAppointmentRequestMessage)]
    [DataContract]
    public class TmpHealthShareMakeAndCancelAppointmentRequestMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets the CRM Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the PatientIcn.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets the Duration.
        /// </summary>
        [DataMember]
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the StartTime.
        /// </summary>
        [DataMember]
        public string StartTime { get; set; }

        /// <summary>
        /// Gets or sets the VisitStatus.
        /// </summary>
        [DataMember]
        public string VisitStatus { get; set; }

        /// <summary>
        /// Gets or sets the Facility.
        /// </summary>
        [DataMember]
        public string Facility { get; set; }

        /// <summary>
        /// Gets or sets the ClinicIen.
        /// </summary>
        [DataMember]
        public string ClinicIen { get; set; }

        /// <summary>
        /// Gets or sets the ClinicName.
        /// </summary>
        [DataMember]
        public string ClinicName { get; set; }

        /// <summary>
        /// Gets or sets the ProviderEmail.
        /// </summary>
        [DataMember]
        public string ProviderEmail { get; set; }

        /// <summary>
        /// Gets or sets the ConsultId.
        /// </summary>
        [DataMember]
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or sets the ConsultName.
        /// </summary>
        [DataMember]
        public string ConsultName { get; set; }

        /// <summary>
        /// Gets or sets the CancelReason.
        /// </summary>
        [DataMember]
        public string CancelReason { get; set; }

        /// <summary>
        /// Gets or sets the CancelCode.
        /// </summary>
        [DataMember]
        public string CancelCode { get; set; }

        /// <summary>
        /// Gets or sets the CancelRemarks.
        /// </summary>
        [DataMember]
        public string CancelRemarks { get; set; }

        /// <summary>
        /// Gets or sets the SchedulerName.
        /// </summary>
        [DataMember]
        public string SchedulerName { get; set; }

        /// <summary>
        /// Gets or sets the SchedulerEmail.
        /// </summary>
        [DataMember]
        public string SchedulerEmail { get; set; }
    }
}