﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// Tmp HealthShare Get Consults Response.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareGetConsultsResponse)]
    [DataContract]
    public class TmpHealthShareGetConsultsResponse : TmpVimtResponseMessage
    {
        /// <summary>
        /// Default Constructor.
        /// </summary>
        public TmpHealthShareGetConsultsResponse()
        {
            PatientConsults = new List<TmpConsult>();
            ProviderConsults = new List<TmpConsult>();
            PatientReturnToClinicOrders = new List<TmpReturnToClinicOrder>();
            ProviderReturnToClinicOrders = new List<TmpReturnToClinicOrder>();
        }

        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        [DataMember]
        public string ControlId { get; set; }

        /// <summary>
        /// Gets or sets Patient DFN.
        /// </summary>
        [DataMember]
        public string PatientDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient ICN.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets Query Name.
        /// </summary>
        [DataMember]
        public string QueryName { get; set; }

        /// <summary>
        /// Gets or sets Institution.
        /// </summary>
        [DataMember]
        public int Institution { get; set; }

        /// <summary>
        /// Gets or sets Patient Consults.
        /// </summary>
        [DataMember]
        public List<TmpConsult> PatientConsults { get; set; }

        /// <summary>
        /// Gets or sets Provider Consults.
        /// </summary>
        [DataMember]
        public List<TmpConsult> ProviderConsults { get; set; }

        /// <summary>
        /// Gets or sets Patient Return to Clinic Orders.
        /// </summary>
        [DataMember]
        public List<TmpReturnToClinicOrder> PatientReturnToClinicOrders { get; set; }

        /// <summary>
        /// Gets or sets Provider Return to Clinic Orders.
        /// </summary>
        [DataMember]
        public List<TmpReturnToClinicOrder> ProviderReturnToClinicOrders { get; set; }
    }

    /// <summary>
    /// Pending Consults.
    /// </summary>
    [DataContract]
    public class TmpConsult
    {
        /// <summary>
        /// Gets or sets ConsultId.
        /// </summary>
        [DataMember]
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        [DataMember]
        public string UniqueRequestId { get; set; }

        /// <summary>
        /// Gets or sets Consult Request Date.
        /// </summary>
        [DataMember]
        public string ConsultRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets To Consult Service.
        /// </summary>
        [DataMember]
        public string ToConsultService { get; set; }

        /// <summary>
        /// Gets or sets Consult Title.
        /// </summary>
        [DataMember]
        public string ConsultTitle { get; set; }

        /// <summary>
        /// Gets or sets Consult Status.
        /// </summary>
        [DataMember]
        public string ConsultStatus { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        [DataMember]
        public string ClinicallyIndicatedDate { get; set; }
        
        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        [DataMember]
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        [DataMember]
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Receiving Site ConsultId.
        /// </summary>
        [DataMember]
        public string ReceivingSiteConsultId { get; set; }
    }

    /// <summary>
    /// Return to Clinic Order.
    /// </summary>
    [DataContract]
    public class TmpReturnToClinicOrder
    {
        /// <summary>
        /// Gets or sets RTC Id.
        /// </summary>
        [DataMember]
        public string RtcId { get; set; }

        /// <summary>
        /// Gets or sets RTC Request DateTime.
        /// </summary>
        [DataMember]
        public string RtcRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets Clinic IEN.
        /// </summary>
        [DataMember]
        public string ToClinicIen { get; set; }

        /// <summary>
        /// Gets or sets Clinic Name.
        /// </summary>
        [DataMember]
        public string ClinicName { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        [DataMember]
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        [DataMember]
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        [DataMember]
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Comments.
        /// </summary>
        [DataMember]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets Multiple Rtc.
        /// </summary>
        [DataMember]
        public string MultiRtc { get; set; }
    }
}