﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.HealthShare
{
    /// <summary>
    /// TMP HealthShare Get Consults Request.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareGetConsultsRequest)]
    [DataContract]
    public class TmpHealthShareGetConsultsRequest : TmpVimtRequestMessage
    {
        /// <summary>
        /// Gets or sets Patient DFN for the Patient Facility.
        /// </summary>
        [DataMember]
        public string PatientStationDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient DFN for the Provider Facility.
        /// </summary>
        [DataMember]
        public string ProviderStationDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient ICN.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets Patient Station Number.
        /// </summary>
        [DataMember]
        public int PatientLoginStationNumber { get; set; }

        [DataMember]
        public List<Guid> PatientIds { get; set; }

        /// <summary>
        /// Gets or sets Provider Site Station Number.
        /// </summary>
        [DataMember]
        public int ProviderLoginStationNumber { get; set; }

        /// <summary>
        /// Gets or sets whether is Home Mobile.
        /// </summary>
        [DataMember]
        public bool IsHomeMobile { get; set; }

        /// <summary>
        /// Gets or sets whether is Store Forward.
        /// </summary>
        [DataMember]
        public bool IsStoreForward { get; set; }
    }
}