﻿using Microsoft.Xrm.Sdk.Client;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.StateObject
{
    /// <summary>
    /// Class used to hold state between VIMT pipeline steps.
    /// </summary>
    public class UpdateClinicStateObject : PipeState
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        /// <param name="requestMessage">TmpHealthShareUpdateClinicRequestMessage instance.</param>
        public UpdateClinicStateObject(TmpHealthShareUpdateClinicRequestMessage requestMessage)
        {
            RequestMessage = requestMessage;
        }

        /// <summary>
        /// Get or set the Request message.
        /// </summary>
        public TmpHealthShareUpdateClinicRequestMessage RequestMessage { get; set; }

        /// <summary>
        /// Get or set the Clinic.
        /// </summary>
        public mcs_resource Clinic { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Get or set TmpHealthShareUpdateClinicResponseMessage.
        /// </summary>
        public TmpHealthShareUpdateClinicResponseMessage ResponseMessage { get; set; }

        /// <summary>
        /// Get or set string respresentation of the Request message.
        /// </summary>
        public string SerializedRequestMessage { get; set; }

        /// <summary>
        /// Get or set whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Get or set the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }
    }
}