﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.UpdateClinic;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.Processor
{
    /// <summary>
    /// HealthShare Update Clinic Processor for VIMT.
    /// </summary>
    public class UpdateClinicProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">TmpHealthShareUpdateClinicRequestMessage.</param>
        /// <returns>TmpHealthShareUpdateClinicResponseMessage.</returns>
        public IMessageBase Execute(TmpHealthShareUpdateClinicRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<UpdateClinicStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, SerializeClinicStep>("SerializeClinicStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, MapClinicStep>("MapClinicStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, CreateAndSaveEntitiesStep>("CreateAndSaveEntitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<UpdateClinicStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new UpdateClinicStateObject(request))
            {
                new Pipeline<UpdateClinicStateObject>()
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("SerializeClinicStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("MapClinicStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("CreateAndSaveEntitiesStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<UpdateClinicStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ResponseMessage;
            }
        }
    }
}