﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.Processor
{
    /// <summary>
    /// HealthShare Make and Cancel Processor for VIMT.
    /// </summary>
    public class MakeCancelProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">TmpHealthShareMakeAndCancelAppointmentRequestMessage.</param>
        /// <returns>TmpHealthShareMakeAndCancelAppointmentResponseMessage.</returns>
        public IMessageBase Execute(TmpHealthShareMakeAndCancelAppointmentRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeCancelStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, SerializeAppointmentStep>("SerializeAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, MapAppointmentStep>("MapAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, CreateAndSaveEntitiesStep>("CreateAndSaveEntitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new MakeCancelStateObject(request))
            {
                new Pipeline<MakeCancelStateObject>()
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("SerializeAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("MapAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("CreateAndSaveEntitiesStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ResponseMessage;
            }
        }
    }
}