﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.Processor
{
    /// <summary>
    /// HealthShare Make and Cancel Outbound Processor for VIMT.
    /// </summary>
    public class MakeCancelOutboundProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">TmpHealthShareMakeCancelOutboundRequestMessage.</param>
        /// <returns>TmpHealthShareMakeCancelOutboundResponseMessage.</returns>
        public IMessageBase Execute(TmpHealthShareMakeCancelOutboundRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, SerializeRequestStep>("SerializeRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetAppointmentStep>("GetAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetFacilitiesStep>("GetFacilitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetClinicsStep>("GetClinicsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, GetVistaIntegrationResultStep>("GetVistaIntegrationResultStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, MapAppointmentStep>("MapAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, SendAppointmentToEcStep>("SendAppointmentToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelOutboundStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new MakeCancelOutboundStateObject(request))
            {
                new Pipeline<MakeCancelOutboundStateObject>()
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("SerializeRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetFacilitiesStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetClinicsStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("GetVistaIntegrationResultStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("MapAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("SendAppointmentToEcStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelOutboundStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ResponseMessage;
            }
        }
    }
}