﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.Processor
{
    /// <summary>
    /// HealthShare Make and Cancel Inbound Processor for VIMT.
    /// </summary>
    public class MakeCancelInboundProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">TmpHealthShareMakeCancelInboundRequestMessage.</param>
        /// <returns>TmpHealthShareMakeCancelInboundResponseMessage.</returns>
        public IMessageBase Execute(TmpHealthShareMakeCancelInboundRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, SerializeInboundRequestStep>("SerializeInboundRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetIntegrationResultStep>("GetIntegrationResultStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetOutboundRequestMessageStep>("GetOutboundRequestMessageStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetOutboundEcRequestMessageStep>("GetOutboundEcRequestMessageStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetPatientIdStep>("GetPatientIdStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetServiceAppointmentStep>("GetServiceAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetAppointmentTypeStep>("GetAppointmentTypeStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, GetAppointmentStep>("GetAppointmentStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, SaveEntitiesStep>("SaveEntitiesStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<MakeCancelInboundStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new MakeCancelInboundStateObject(request))
            {
                new Pipeline<MakeCancelInboundStateObject>()
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("SerializeInboundRequestStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetIntegrationResultStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetOutboundRequestMessageStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetOutboundEcRequestMessageStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetPatientIdStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetServiceAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetAppointmentTypeStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("GetAppointmentStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("SaveEntitiesStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<MakeCancelInboundStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ResponseMessage;
            }
        }
    }
}