﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.Processor
{
    /// <summary>
    /// HealthShare Get Consults Processor for VIMT.
    /// </summary>
    public class GetConsultsProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">TmpHealthShareGetConsultsRequest.</param>
        /// <returns>TmpHealthShareGetConsultsResponse.</returns>
        public IMessageBase Execute(TmpHealthShareGetConsultsRequest request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<GetConsultsStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, SerializeConsultsStep>("SerializeConsultsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, GenerateUniqueIdStep>("GenerateUniqueIdStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, MapConsultsRequestStep>("MapConsultsRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, SendToEcStep>("SendToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, MapConsultsResponseStep>("MapConsultsResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new GetConsultsStateObject(request))
            {
                new Pipeline<GetConsultsStateObject>()
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("SerializeConsultsStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("GenerateUniqueIdStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("MapConsultsRequestStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("SendToEcStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("MapConsultsResponseStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.ResponseMessage;
            }
        }
    }
}