﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.HealthShare.Processor;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareUpdateClinicRequestMessage)]
    public class UpdateClinicHandler : RequestResponseHandler
    {
        private TmpHealthShareUpdateClinicRequestMessage _request;

        /// <summary>
        /// Handle the HealthShare Update Clinic Request and send back a response.
        /// </summary>
        /// <param name="message">TmpHealthShareUpdateClinicRequestMessage.</param>
        /// <returns>TmpHealthShareUpdateClinicResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                if(message == null)
                {
                    var errorMessage = $"ERROR: The message object parameter in UpdateClinicHandler.HandleRequestResponse is NULL/INVALID: {message}";
                    throw new ArgumentNullException("message", errorMessage);
                }

                _request = (TmpHealthShareUpdateClinicRequestMessage)message;

                var requestProcessor = new UpdateClinicProcessor();
                var response = (TmpHealthShareUpdateClinicResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: HealthShare Update Clinic: {0}", response.ExceptionMessage));

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>TmpHealthShareUpdateClinicResponseMessage.</returns>
        private static TmpHealthShareUpdateClinicResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: HealthShare Update Clinic Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new TmpHealthShareUpdateClinicResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage
            };
        }
    }
}