﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.HealthShare.Processor;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareMakeAndCancelAppointmentRequestMessage)]
    public class MakeCancelHandler : RequestResponseHandler
    {
        private TmpHealthShareMakeAndCancelAppointmentRequestMessage _request;

        /// <summary>
        /// Handle the HealthShare Make and Cancel Appointment Request and send back a response.
        /// </summary>
        /// <param name="message">TmpHealthShareMakeAndCancelAppointmentRequestMessage.</param>
        /// <returns>TmpHealthShareMakeAndCancelAppointmentResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                if (message == null)
                {
                    var errorMessage = $"ERROR: The message object parameter in MakeCancelHandler.HandleRequestResponse is NULL/INVALID: {message}";
                    throw new ArgumentNullException("message", errorMessage);
                }

                _request = (TmpHealthShareMakeAndCancelAppointmentRequestMessage)message;

                var requestProcessor = new MakeCancelProcessor();
                var response = (TmpHealthShareMakeAndCancelAppointmentResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: HealthShare Make And Cancel Appointment: {0}", response.ExceptionMessage));

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>TmpHealthShareMakeAndCancelAppointmentResponseMessage.</returns>
        private static TmpHealthShareMakeAndCancelAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: HealthShare Make and Cancel Handler Exception WMC", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new TmpHealthShareMakeAndCancelAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage
            };
        }
    }
}